ORCA/M Asm65816 2.1.0

0001 E1CF                       title 'Event Manager        GS ROM 3.0' 
0002 E1CF              ********************************************************
0003 E1CF              *                                                      *
0004 E1CF              *                 Event Manager                        *
0005 E1CF              *                                                      *
0006 E1CF              ********************************************************
0007 E1CF
0008 E1CF              ********************************************************
0009 E1CF              *                                                      *
0010 E1CF              *              Copyright (C) 1985-1989                 *
0011 E1CF              *              Apple Computer, Inc.                    *
0012 E1CF              *              All Rights Reserved                     *
0013 E1CF              *                                                      *
0014 E1CF              ********************************************************
0015 E1CF
0016 E1CF
0017 E1CF              ********************************************************
0018 E1CF              *                                                      *
0019 E1CF              * Change History                                       *
0020 E1CF              *                                                      *
0021 E1CF              * Version 2.0                                          *
0022 E1CF              *                                                      *
0023 E1CF              *   Summer 86            Cherly Ewy                    *
0024 E1CF              *                                                      *
0025 E1CF              *   Posting an illegal event code won't crash the      *
0026 E1CF              *   system.                                            *
0027 E1CF              *                                                      *
0028 E1CF              *   December 23, 1986        SEG                       *
0029 E1CF              *                                                      *
0030 E1CF              *   EMStartup and EMShutdown were modified to save a   *
0031 E1CF              *   few bytes.  All the PushWord #0 lines that were putting  *
0032 E1CF              *   result space on the stack were changed to PHA.     *
0033 E1CF              *   All the Get and Set vector calls went through      *
0034 E1CF              *   glue routines, saving 3 bytes each for 45 bytes.   *
0035 E1CF              *   The NewHandle call was replaced with a call to     *
0036 E1CF              *   SpecialNewHandle.                                  *
0037 E1CF              *                                                      *
0038 E1CF              *   February 27, 1987        Cheryl Ewy                *
0039 E1CF              *                                                      *
0040 E1CF              *   Auto key events are no longer posted unless        *
0041 E1CF              *   the queue is empty.                                *
0042 E1CF              *                                                      *
0043 E1CF              *   June 13, 1988            Joe Bo                    *
0044 E1CF              *                                                      *
0045 E1CF              *   Change locations for double click time ($2E to $38)*
0046 E1CF              *   and cursor flash rate ($2F to $2E) in battery ram. *
0047 E1CF              *                                                      *
0048 E1CF              *   Change EMStartUp & FakeMouse routines for only     *
0049 E1CF              *   ADB mouse to work with.                            *
0050 E1CF              *                                                      *
0051 E1CF              *
0052 E1CF              * 29 Jun 88	Steven Glass
0053 E1CF              *
0054 E1CF              * Two things were wrong in TickCount.  First the TickCnt 
0055 E1CF              * was being accessed with interrupts active and second, 
0056 E1CF              * if journaling was active, the journaling code was 
0057 E1CF              * called with the wrong direct page register.
0058 E1CF              *
0059 E1CF              * 30 Jun 88	Steven Glass & Cheryl Ewy
0060 E1CF              *
0061 E1CF              * Changed post event to look at AutoKeyLimit when
0062 E1CF              * posting AutoKey events.
0063 E1CF              *
0064 E1CF              * Added call SetAutoKeyLimit.
0065 E1CF              *
0066 E1CF              * 21 Jan 89	Mensch
0067 E1CF              * 
0068 E1CF              * Added kTrans table support in EMStartup, getNextEvent
0069 E1CF              * and EventAvail.
0070 E1CF              *
0071 E1CF              * Changed all ReadMouse calls to ReadMouse2 calls.
0072 E1CF              * 
0073 E1CF              * 26 Jan 89	Mensch
0074 E1CF              *
0075 E1CF              * Modified ktrans stuff to use the batery RAM location $5A
0076 E1CF              * to get our resource ID.
0077 E1CF              *
0078 E1CF              * 07 Feb 89	Mensch
0079 E1CF              *
0080 E1CF              * Added GetKeyTranslation & SetKeyTranslation calls, modified the 
0081 E1CF              * startup stuff so it doesn't crash when you have picked none.
0082 E1CF              * from the control panel for key remapping.
0083 E1CF              *
0084 E1CF              * 13 Feb 89	Mensch
0085 E1CF              *
0086 E1CF              * Fix emstartup to properly call the new setkeytranslation 
0087 E1CF              * routine.
0088 E1CF              *
0089 E1CF              *
0090 E1CF              *
0091 E1CF              *
0092 E1CF              *  3/20/89	Mark Cecys
0093 E1CF              *
0094 E1CF              *  Added "MIDIInputPoll" in time-consuming routines. If assem directive "midi"
0095 E1CF              *  is set to one, then polling will be assembled, otherwise if set to zero,
0096 E1CF              *  no MIDI polling will be added. This is used by MidiTools which patches in
0097 E1CF              *  its local cursor routines to prevent SCC over-run. (EM makefile has midi=0)
0098 E1CF              *  The following PROC's are affected:
0099 E1CF              *	PostEvent
0100 E1CF              *	GetOSEvent
0101 E1CF              *	DeQueue
0102 E1CF              *	FillRecord
0103 E1CF              *	Mouse
0104 E1CF              *
0105 E1CF              * 26-Sep-90	Dave Lyons
0106 E1CF              *
0107 E1CF              * Change SysDeathMgr to SysFailMgr to make it build
0108 E1CF              * with current interfaces.
0109 E1CF              *
0110 E1CF              ********************************************************
0111 E1CF
0112 E1CF                       include 'all.macros' 
0113 E1CF                       include '::sys.equs.asm' 
0114 E1CF
0115 E1CF              EMVerNum equ   $0300                    ;V3.0
0116 E1CF
0117 E1CF              *---------------------------------------------------------------
0118 E1CF              * Constants
0119 E1CF              *---------------------------------------------------------------
0120 E1CF
0121 E1CF              True     equ   $0001
0122 E1CF              False    equ   $0000
0123 E1CF              EMTSNum  equ   6                        ;tool set num for Event Mgr
0124 E1CF              InitErr  equ   $0601                    ;duplicate init call
0125 E1CF              ResetErr equ   $0602                    ;can't reset Event Mgr
0126 E1CF              ActiveErr equ   $0603                   ;Event Mgr not active
0127 E1CF              CodeErr  equ   $0604                    ;illegal event code
0128 E1CF              BtnErr   equ   $0605                    ;illegal button number
0129 E1CF              SizeErr  equ   $0606                    ;queue size too large
0130 E1CF              MemErr   equ   $0607                    ;not enough mem for queue
0131 E1CF              QError   equ   $0681                    ;fatal system error - damaged queue
0132 E1CF              HError   equ   $0682                    ;fatal system error - damaged Q handle
0133 E1CF              TaskSig  equ   $A55A                    ;signature word for heartbeat task
0134 E1CF              KeyBufParam equ   $2B                   ;for ReadBParam call
0135 E1CF              ClickParam equ   $2E                    ;     "
0136 E1CF              FlashParam equ   $2F                    ;     "
0137 E1CF              MouseDown equ   1                       ;event code
0138 E1CF              MouseUp  equ   2                        ;     "
0139 E1CF              KeyDown  equ   3                        ;     "
0140 E1CF              AutoKey  equ   5                        ;     "
0141 E1CF              Update   equ   6                        ;     "
0142 E1CF              Activate equ   8                        ;     "
0143 E1CF              Switch   equ   9                        ;     "
0144 E1CF              DeskAccessory equ   10                  ;     "
0145 E1CF              BUpdate  equ   $0040                    ;bit 6 set
0146 E1CF              BActivate equ   $0100                   ;bit 8 set
0147 E1CF              BSwitch  equ   $0200                    ;bit 9 set
0148 E1CF              Btn0bit  equ   $0080                    ;used with modifiers field
0149 E1CF              Btn1bit  equ   $0040                    ;     "
0150 E1CF              RepeatBit equ   $0800                   ;used with mod keys latch
0151 E1CF              MovedBit equ   $2000                    ;used with BStat
0152 E1CF              MoveIntBit equ   $0002                  ;     "
0153 E1CF              BtnIntBit equ   $0004                   ;     "
0154 E1CF              JcTickCount equ   0                     ;journal code
0155 E1CF              JcGetMouse equ   1                      ;     "
0156 E1CF              JcButton equ   2                        ;     "
0157 E1CF              JcEvent  equ   4                        ;     "
0158 E1CF              EvtSize  equ   16                       ;size of event record in bytes
0159 E1CF              EvtQSize equ   18                       ;size of event record incl link field
0160 E1CF              DefaultQ equ   20                       ;default queue size
0161 E1CF              MaxQ     equ   3639                     ;max queue size
0162 E1CF              MsgOffset equ   2                       ;offset to Message field
0163 E1CF              WhenOffset equ   6                      ;offset to When field
0164 E1CF              WhereOffset equ   10                    ;offset to Where field
0165 E1CF              ModsOffset equ   14                     ;offset to Modifiers field
0166 E1CF              EvtOffset equ   2                       ;offset to event record from start of
0167 E1CF              ;                                       ;event queue element
0168 E1CF              KindOffset equ   4                      ;offset to WindowKind field in window
0169 E1CF
0170 E1CF              *---------------------------------------------------------------
0171 E1CF              * Hardware Equates
0172 E1CF              *---------------------------------------------------------------
0173 E1CF
0174 E1CF              MouseMode equ   $7F8                    ;mouse mode byte
0175 E1CF              KeyLatch equ   $C000                    ;keyboard keypress latch
0176 E1CF              KbdStrobe equ   $C010                   ;keyboard strobe
0177 E1CF              ModLatch equ   $C025                    ;keyboard modifiers latch
0178 E1CF              CardType equ   $C02D                    ;bit 4 specifies internal/external card
0179 E1CF
0180 E1CF              *---------------------------------------------------------------
0181 E1CF              * Event Manager Zero Page
0182 E1CF              *---------------------------------------------------------------
0183 E1CF
0184 E1CF              EMZBase  equ   0
0185 E1CF              TempEvent equ   EMZBase
0186 E1CF              UserEvtPtr equ   TempEvent+16
0187 E1CF              JResultPtr equ   UserEvtPtr+4
0188 E1CF              SaveLink equ   JResultPtr+4
0189 E1CF              TempLink equ   SaveLink+2
0190 E1CF              TempPtr  equ   TempLink+2
0191 E1CF              TempBits equ   TempPtr+4
0192 E1CF              SysEventMask equ   TempBits+2           ;system event mask
0193 E1CF              QHandle  equ   SysEventMask+2           ;handle for event queue
0194 E1CF              QPtr     equ   QHandle+4                ;pointer to event queue
0195 E1CF              QSize    equ   QPtr+4                   ;max number of events in queue
0196 E1CF              QHead    equ   QSize+2                  ;link to first queue element
0197 E1CF              QTail    equ   QHead+2                  ;link to last queue element
0198 E1CF              CheckButton equ   QTail+2
0199 E1CF              WhichButton equ   CheckButton+2
0200 E1CF              GotSwitchCall equ   WhichButton+2       ;1 if switch event pending, 0 if not
0201 E1CF              WindowMgr equ   GotSwitchCall+2         ;1 if Window Mgr init, 0 if not
0202 E1CF              RemoveEvent equ   WindowMgr+2           ;flag used by GetNextEvent
0203 E1CF              OSRemoveEvent equ   RemoveEvent+2       ;flag used by GetOSEvent
0204 E1CF              GotMouse equ   OSRemoveEvent+2          ;1 if mouse present, 0 if not
0205 E1CF              ExtMouse equ   GotMouse+2               ;1 if external mouse, 0 if not
0206 E1CF              MouseAdrs equ   ExtMouse+2              ;original mouse vector
0207 E1CF              KBAdrs   equ   MouseAdrs+4              ;original keyboard vector
0208 E1CF              DAAdrs   equ   KBAdrs+4                 ;original desk accesory vector
0209 E1CF              FBAdrs   equ   DAAdrs+4                 ;original flush buffer vector
0210 E1CF              VBLAdrs  equ   FBAdrs+4                 ;original VBL vector
0211 E1CF              KBufOn   equ   VBLAdrs+4                ;1 if keyboard buffering on before init
0212 E1CF              KBOn     equ   KBufOn+2                 ;1 if keyboard interrupts on before init
0213 E1CF              VBLOn    equ   KBOn+2                   ;1 if VBL interrupts on before init
0214 E1CF              SaveMode equ   VBLOn+2                  ;original mouse mode
0215 E1CF              SaveP    equ   SaveMode+2               ;original processor status
0216 E1CF              ProgID   equ   SaveP+2                  ;program ID used with mem mgr
0217 E1CF              FromGNE  equ   ProgID+2                 ;flag used by GetOSEvent
0218 E1CF
0219 E1CF              AutoKeyLimit equ   FromGNE+2            ; added 30 Jun 88 SEG
0220 E1CF              ktransRef equ   AutoKeyLimit+2          ; added 1/22/89 Mensch (4 byte)
0221 E1CF              kTransFlag equ   kTransRef+4            ; added 1/23/89 Mensch (2 Byte)
0222 E1CF              kTransTemp equ   kTransFlag+2           ; added 4/19/89 Mensch (2 Byte)
0223 E1CF              ;
0224 E1CF              kTransBParamLoc equ   $5A               ; battery ram parameter we use...
0225 E1CF              *---------------------------------------------------------------
0226 E1CF              * Window Manager Zero Page (used by Event Manager)
0227 E1CF              *---------------------------------------------------------------
0228 E1CF
0229 E1CF              WMZBase  equ   128
0230 E1CF              FlgActive equ   WMZBase
0231 E1CF              FlgDeActive equ   FlgActive+2
0232 E1CF              CurActive equ   FlgDeActive+2
0233 E1CF              CurDeActive equ   CurActive+4
0234 E1CF              CurDeKind equ   CurDeActive+4
0235 E1CF
0236 E1CF
0237 E1CF
0238 E1CF              ;-----------------------------------------------
0239 E1CF              ;
0240 E1CF              ;   Imported addresses
0241 E1CF              ;
0242 E1CF              ;-----------------------------------------------
0243 E1CF
0244 E1CF                       IMPORT EndCall0 
0245 E1CF                       IMPORT EndCall10 
0246 E1CF                       IMPORT EndCall14 
0247 E1CF                       IMPORT EndCall2 
0248 E1CF                       IMPORT EndCall4 
0249 E1CF                       IMPORT EndCall6 
0250 E1CF                       IMPORT ErrOut0 
0251 E1CF                       IMPORT ErrOut10 
0252 E1CF                       IMPORT ErrOut14 
0253 E1CF                       IMPORT ErrOut2 
0254 E1CF                       IMPORT ErrOut4 
0255 E1CF                       IMPORT ErrOut6 
0256 E1CF                       IMPORT GetVectorGlue 
0257 E1CF                       IMPORT IRQ_Heart 
0258 E1CF                       IMPORT MouseEquates 
0259 E1CF                       IMPORT SetVectorGlue 
0260 E1CF                       IMPORT SpecialNewHandle 
0261 E1CF                       IMPORT oEndCall0 
0262 E1CF                       IMPORT oErrOut0 
0263 E1CF                       IMPORT oErrOut14 
0264 E1CF
0265 E1CF              ;-----------------------------------------------
0266 E1CF              ;
0267 E1CF              ;   Forward addresses and entries
0268 E1CF              ;
0269 E1CF              ;-----------------------------------------------
0270 E1CF
0271 E1CF                       ENTRY Button 
0272 E1CF                       ENTRY DeQueue 
0273 E1CF                       ENTRY DeskAcc 
0274 E1CF                       ENTRY DoJournal 
0275 E1CF                       ENTRY DoWindows 
0276 E1CF                       ENTRY EMActive 
0277 E1CF                       ENTRY EMBootInit 
0278 E1CF                       ENTRY EMReset 
0279 E1CF                       ENTRY EMShutDown 
0280 E1CF                       ENTRY EMStartUp 
0281 E1CF                       ENTRY EMVersion 
0282 E1CF                       ENTRY EnQueue 
0283 E1CF                       ENTRY EventAvail 
0284 E1CF                       ENTRY FakeMouse 
0285 E1CF                       ENTRY FillRecord 
0286 E1CF                       ENTRY FlushBuf 
0287 E1CF                       ENTRY FlushEvents 
0288 E1CF                       ENTRY GetCaretTime 
0289 E1CF                       ENTRY GetDblTime 
0290 E1CF                       ENTRY GetGlobalLoc 
0291 E1CF                       ENTRY GetMouse 
0292 E1CF                       ENTRY GetNextEvent 
0293 E1CF                       ENTRY GetOSEvent 
0294 E1CF                       ENTRY KeyBoard 
0295 E1CF                       ENTRY LockQ 
0296 E1CF                       ENTRY Mouse 
0297 E1CF                       ENTRY Mouse3 
0298 E1CF                       ENTRY MouseTask 
0299 E1CF                       ENTRY OSEventAvail 
0300 E1CF                       ENTRY PostEvent 
0301 E1CF                       ENTRY SetEventMask 
0302 E1CF                       ENTRY SetModBits 
0303 E1CF                       ENTRY SetSwitch 
0304 E1CF                       ENTRY StillDown 
0305 E1CF                       ENTRY TickCount 
0306 E1CF                       ENTRY UnLockQ 
0307 E1CF                       ENTRY WaitMouseUp 
0308 E1CF                       Entry GetKeyTranslation 
0309 E1CF                       Entry SetKeyTranslation 
0310 E1CF
0311 E1CF              ****************************************************************
0312 E1CF              *
0313 E1CF              * CALL TABLE
0314 E1CF              *
0315 E1CF              ****************************************************************
0316 E1CF
0317 E1CF                       EXPORT EMCallTable 
0318 E1CF              EMCallTable PROC 
0319 E1CF                       import SetAutoKeyLimit 
0320 E1CF
0321 E1CF
0322 E1CF 1D 00 00 00           DC L:(TheEnd-EMCallTable)/4    ;num calls + 1
0323 E1D3 9F E2 FE 00           DC L:EMBootInit-1
0324 E1D7 A2 E2 FE 00           DC L:EMStartUp-1
0325 E1DB B6 E4 FE 00           DC L:EMShutDown-1
0326 E1DF 9C E5 FE 00           DC L:EMVersion-1
0327 E1E3 A4 E5 FE 00           DC L:EMReset-1
0328 E1E7 B2 E5 FE 00           DC L:EMActive-1
0329 E1EB DE FB FE 00           DC L:oEndCall0-1
0330 E1EF DE FB FE 00           DC L:oEndCall0-1
0331 E1F3 B7 E5 FE 00           DC L:DoWindows-1
0332 E1F7 CB E5 FE 00           DC L:GetNextEvent-1
0333 E1FB 41 E7 FE 00           DC L:EventAvail-1
0334 E1FF 4E E7 FE 00           DC L:GetMouse-1
0335 E203 8D E7 FE 00           DC L:Button-1
0336 E207 CD E7 FE 00           DC L:StillDown-1
0337 E20B 26 E8 FE 00           DC L:WaitMouseUp-1
0338 E20F 78 E8 FE 00           DC L:TickCount-1
0339 E213 AC E8 FE 00           DC L:GetDblTime-1
0340 E217 D9 E8 FE 00           DC L:GetCaretTime-1
0341 E21B 06 E9 FE 00           DC L:SetSwitch-1
0342 E21F 18 E9 FE 00           DC L:PostEvent-1
0343 E223 B7 E9 FE 00           DC L:FlushEvents-1
0344 E227 14 EA FE 00           DC L:GetOSEvent-1
0345 E22B DB EA FE 00           DC L:OSEventAvail-1
0346 E22F E8 EA FE 00           DC L:SetEventMask-1
0347 E233 F9 EA FE 00           DC L:FakeMouse-1               	; $1906
0348 E237 16 EF FE 00           DC L:SetAutoKeyLimit-1         ; $1A06
0349 E23B 2A EF FE 00           DC L:GetKeyTranslation-1       ; 2/7/89 {$1B06}
0350 E23F 4E EF FE 00           DC L:SetKeyTranslation-1       ; 2/7/89 {$1C06}
0351 E243
0352 E243              TheEnd                                  ; 
0353 E243                       ENDP 
0354 E243
0355 E243              ;                APPEND init
0356 E243
0357 E243
0358 E243
0359 E243              ****************************************************************
0360 E243              *
0361 E243              * DATA DECLARATIONS
0362 E243              *
0363 E243              ****************************************************************
0364 E243
0365 E243                       EXPORT EMData 
0366 E243              EMData   PROC 
0367 E243
0368 E243
0369 E243              *---------------------------------------------------------------
0370 E243              * Tables
0371 E243              *---------------------------------------------------------------
0372 E243
0373 E243                       EXPORT BStatMask 
0374 E243 00 80        BStatMask DC B:%00000000,%10000000      ;button 0 mask
0375 E245 00 10                 DC B:%00000000,%00010000       ;button 1 mask
0376 E247
0377 E247                       EXPORT MaskTable 
0378 E247 01 00        MaskTable DC B:%00000001,%00000000
0379 E249 02 00                 DC B:%00000010,%00000000
0380 E24B 04 00                 DC B:%00000100,%00000000
0381 E24D 08 00                 DC B:%00001000,%00000000
0382 E24F 10 00                 DC B:%00010000,%00000000
0383 E251 20 00                 DC B:%00100000,%00000000
0384 E253 40 00                 DC B:%01000000,%00000000
0385 E255 80 00                 DC B:%10000000,%00000000
0386 E257 00 01                 DC B:%00000000,%00000001
0387 E259 00 02                 DC B:%00000000,%00000010
0388 E25B 00 04                 DC B:%00000000,%00000100
0389 E25D 00 08                 DC B:%00000000,%00001000
0390 E25F 00 10                 DC B:%00000000,%00010000
0391 E261 00 20                 DC B:%00000000,%00100000
0392 E263 00 40                 DC B:%00000000,%01000000
0393 E265 00 80                 DC B:%00000000,%10000000
0394 E267
0395 E267                       EXPORT ModBitTable 
0396 E267 00 02        ModBitTable DC B:%00000000,%00000010    ;ShiftKey bit
0397 E269 00 10                 DC B:%00000000,%00010000       ;ControlKey bit
0398 E26B 00 04                 DC B:%00000000,%00000100       ;CapsLock bit
0399 E26D 00 00                 DC B:%00000000,%00000000
0400 E26F 00 20                 DC B:%00000000,%00100000       ;KeyPad bit
0401 E271 00 00                 DC B:%00000000,%00000000
0402 E273 00 08                 DC B:%00000000,%00001000       ;OptionKey bit
0403 E275 00 01                 DC B:%00000000,%00000001       ;AppleKey bit
0404 E277
0405 E277                       EXPORT ClickTable 
0406 E277 32 00 00 00  ClickTable DC L:50
0407 E27B 28 00 00 00           DC L:40
0408 E27F 1E 00 00 00           DC L:30
0409 E283 14 00 00 00           DC L:20
0410 E287 0A 00 00 00           DC L:10
0411 E28B
0412 E28B                       EXPORT FlashTable 
0413 E28B 00 00 00 00  FlashTable DC L:0                       ;no flash
0414 E28F 3C 00 00 00           DC L:60
0415 E293 1E 00 00 00           DC L:30
0416 E297 0F 00 00 00           DC L:15
0417 E29B 0A 00 00 00           DC L:10
0418 E29F
0419 E29F                       EXPORT FDBData 
0420 E29F 10           FDBData  DC B:$10                       ;data byte used for FDB tool call
0421 E2A0
0422 E2A0                       ENDP 
0423 E2A0
0424 E2A0
0425 E2A0
0426 E2A0
0427 E2A0              ****************************************************************
0428 E2A0              *
0429 E2A0              * EMBootInit
0430 E2A0              *
0431 E2A0              ****************************************************************
0432 E2A0
0433 E2A0                       EXPORT EMBootInit 
0434 E2A0              EMBootInit PROC 
0435 E2A0 4C DF FB              jmp   oEndCall0
0436 E2A3                       ENDP 
0437 E2A3
0438 E2A3
0439 E2A3
0440 E2A3              ****************************************************************
0441 E2A3              *
0442 E2A3              * EMStartUp
0443 E2A3              *
0444 E2A3              * Modified 1/22/89 Mensch
0445 E2A3              * Calls the DoLoadKTrans routine at startup to load the current ktrans table
0446 E2A3              * and store a pointer to it in direct page.
0447 E2A3              *
0448 E2A3              * See beginning of file. --DAL
0449 E2A3              *
0450 E2A3              ****************************************************************
0451 E2A3
0452 E2A3                       EXPORT EMStartUp 
0453 E2A3              EMStartUp PROC 
0454 E2A3                       Import DoLoadKTrans 
0455 E2A3                       import UseCoolMousePos 
0456 E2A3
0457 E2A3 C9 00 00              cmp   #0                       ;already initialized?
0458 E2A6 F0 06                 beq   Doit                     ;no
0459 E2A8 A2 01 06              ldx   #InitErr                 ;yes - so return error
0460 E2AB 4C 80 FC              jmp   oErrOut14
0461 E2AE
0462 E2AE 0B           Doit     phd   
0463 E2AF A3 15                 lda   21,s                     ;get zero page address
0464 E2B1 5B                    tcd   
0465 E2B2
0466 E2B2 A2 FE 00              ldx   #$FE
0467 E2B5 74 00        Loop     stz   <EMZBase,x               ;clear zero page
0468 E2B7 CA                    dex   
0469 E2B8 CA                    dex   
0470 E2B9 10 FA                 bpl   Loop
0471 E2BB
0472 E2BB A9 00 00              lda   #0
0473 E2BE A2 0A 00              ldx   #10                      ;12 bytes to clear
0474 E2C1 9F E1 00 E1  Loop2    sta   >EvMgrData,x             ;clear permanent data area
0475 E2C5 CA                    dex   
0476 E2C6 CA                    dex   
0477 E2C7 10 F8                 bpl   Loop2
0478 E2C9
0479 E2C9 A3 09                 lda   9,s                      ;get program ID
0480 E2CB 85 60                 sta   <ProgID
0481 E2CD
0482 E2CD A3 13                 lda   19,s                     ;get queue size (# event records)
0483 E2CF D0 03                 bne   CheckSize
0484 E2D1 A9 14 00              lda   #DefaultQ                ;default queue size
0485 E2D4 C9 38 0E     CheckSize cmp   #MaxQ+1
0486 E2D7 90 06                 bcc   OK
0487 E2D9 A2 06 06              ldx   #SizeErr                 ;queue size too big
0488 E2DC 4C 7F FC              jmp   ErrOut14
0489 E2DF
0490 E2DF 1A           OK       inc   a                        ;first element of Q never used
0491 E2E0 85 2C                 sta   <QSize
0492 E2E2 0A                    asl   a                        ;multiply queue size by 18 to get
0493 E2E3 0A                    asl   a                        ;size in bytes
0494 E2E4 0A                    asl   a                        ;QSize * 8
0495 E2E5 18                    clc   
0496 E2E6 65 2C                 adc   <QSize                   ;QSize * 9
0497 E2E8 0A                    asl   a                        ;QSize * 18
0498 E2E9
0499 E2E9 A6 60                 ldx   <ProgID
0500 E2EB A0 04 00              ldy   #$0004                   ; page aligned, unpurgeable
0501 E2EE 20 3B 13              jsr   SpecialNewHandle
0502 E2F1
0503 E2F1 90 06                 bcc   GotMem
0504 E2F3 A2 07 06              ldx   #MemErr
0505 E2F6 4C 7F FC              jmp   ErrOut14
0506 E2F9
0507 E2F9 86 24        GotMem   stx   <QHandle
0508 E2FB 84 26                 sty   <QHandle+2
0509 E2FD 20 A0 EB              jsr   LockQ                    ;lock Q and dereference handle
0510 E300
0511 E300 A6 2C                 ldx   <QSize
0512 E302 A0 02 00              ldy   #EvtOffset               ;offset to event code in element
0513 E305 A9 FF FF     QLoop    lda   #$FFFF
0514 E308 97 28                 sta   [<QPtr],y                ;mark all Q elements as free
0515 E30A 98                    tya   
0516 E30B 18                    clc   
0517 E30C 69 12 00              adc   #EvtQSize
0518 E30F A8                    tay   
0519 E310 CA                    dex   
0520 E311 D0 F2                 bne   QLoop
0521 E313
0522 E313 A9 EE EE              lda   #$EEEE
0523 E316 A0 02 00              ldy   #EvtOffset
0524 E319 97 28                 sta   [<QPtr],y                ;mark first Q element as used
0525 E31B
0526 E31B 20 CC EB              jsr   UnLockQ                  ;unlock queue
0527 E31E
0528 E31E A9 FF FF              lda   #$FFFF                   ;init system event mask to post
0529 E321 85 22                 sta   <SysEventMask            ;all events
0530 E323
0531 E323 08                    php   
0532 E324 08                    php   
0533 E325 68                    pla                            ;save original processor status
0534 E326 85 5E                 sta   <SaveP
0535 E328 78                    sei                            ;turn off interrrupts
0536 E329
0537 E329 48                    pha                            ;get status of hardware interrupts
0538 E32A A2 03 29 22           _GetIRQEnable 
0539 E331 68                    pla   
0540 E332 EB                    xba   
0541 E333 2A                    rol   a
0542 E334 26 58                 rol   <KBOn                    ;set flag if keyboard interrupts on
0543 E336 2A                    rol   a
0544 E337 26 5A                 rol   <VBLOn                   ;set flag if VBL interrupts on
0545 E339              ;                                       ;save original interrupt vectors
0546 E339 48                    pha   
0547 E33A 48                    pha   
0548 E33B F4 0D 00              PushWord #$0D                  ;mouse
0549 E33E 22 36 13 FE           jsl   GetVectorGlue
0550 E342 68                    pla   
0551 E343 85 42                 sta   <MouseAdrs
0552 E345 68                    pla   
0553 E346 85 44                 sta   <MouseAdrs+2
0554 E348
0555 E348 48                    pha   
0556 E349 48                    pha   
0557 E34A F4 0F 00              PushWord #$0F                  ;keyboard
0558 E34D 22 36 13 FE           jsl   GetVectorGlue
0559 E351 68                    pla   
0560 E352 85 46                 sta   <KBAdrs
0561 E354 68                    pla   
0562 E355 85 48                 sta   <KBAdrs+2
0563 E357
0564 E357 48                    pha   
0565 E358 48                    pha   
0566 E359 F4 12 00              PushWord #$12                  ;desk accessory
0567 E35C 22 36 13 FE           jsl   GetVectorGlue
0568 E360 68                    pla   
0569 E361 85 4A                 sta   <DAAdrs
0570 E363 68                    pla   
0571 E364 85 4C                 sta   <DAAdrs+2
0572 E366
0573 E366 48                    pha   
0574 E367 48                    pha   
0575 E368 F4 13 00              PushWord #$13                  ;flush buffer
0576 E36B 22 36 13 FE           jsl   GetVectorGlue
0577 E36F 68                    pla   
0578 E370 85 4E                 sta   <FBAdrs
0579 E372 68                    pla   
0580 E373 85 50                 sta   <FBAdrs+2
0581 E375
0582 E375 48                    pha   
0583 E376 48                    pha   
0584 E377 F4 0C 00              PushWord #$0C                  ;VBL
0585 E37A 22 36 13 FE           jsl   GetVectorGlue
0586 E37E 68                    pla   
0587 E37F 85 52                 sta   <VBLAdrs
0588 E381 68                    pla   
0589 E382 85 54                 sta   <VBLAdrs+2
0590 E384                                                      ;install interrupt handlers
0591 E384 F4 0D 00              PushWord #$0D 
0592 E387 F4 FE 00 F4           PushPtr Mouse                  ;mouse
0593 E38D 22 31 13 FE           jsl   SetVectorGlue
0594 E391 F4 0F 00              PushWord #$0F 
0595 E394 F4 FE 00 F4           PushPtr KeyBoard               ;keyboard
0596 E39A 22 31 13 FE           jsl   SetVectorGlue
0597 E39E F4 12 00              PushWord #$12 
0598 E3A1 F4 FE 00 F4           PushPtr DeskAcc                ;desk accessory
0599 E3A7 22 31 13 FE           jsl   SetVectorGlue
0600 E3AB F4 13 00              PushWord #$13 
0601 E3AE F4 FE 00 F4           PushPtr FlushBuf               ;flush buffer
0602 E3B4 22 31 13 FE           jsl   SetVectorGlue
0603 E3B8 F4 0C 00              PushWord #$0C 
0604 E3BB F4 FE 00 F4           PushPtr IRQ_Heart              ;VBL
0605 E3C1 22 31 13 FE           jsl   SetVectorGlue
0606 E3C5
0607 E3C5 48                    pha                            ;result
0608 E3C6 F4 2B 00              PushWord #KeyBufParam          ;get status of keyboard buffering
0609 E3C9 A2 03 0C 22           _ReadBParam 
0610 E3D0 68                    pla   
0611 E3D1 85 56                 sta   <KBufOn
0612 E3D3 D0 13                 bne   DoInts                   ;keyboard buffering is on
0613 E3D5
0614 E3D5 F4 01 00              PushWord #1                    ;# of data bytes
0615 E3D8 F4 FE 00 F4           PushPtr FDBData                ;push address of data byte
0616 E3DE F4 04 00              PushWord #4                    ;mode cmd
0617 E3E1 A2 09 09 22           _SendInfo                      ;(_FDBCmd)  ;enable keyboard buffering
0618 E3E8
0619 E3E8 F4 02 00     DoInts   PushWord #2                    ;enable VBL interrupts
0620 E3EB A2 03 23 22           _IntSource 
0621 E3F2 F4 00 00              PushWord #0                    ;enable keyboard interrupts
0622 E3F5 A2 03 23 22           _IntSource 
0623 E3FC F4 0A 00              PushWord #10                   ;enable data reg interrupts
0624 E3FF A2 03 23 22           _IntSource 
0625 E406
0626 E406 AF DF 00 E1           lda   >MouseSlot-1             ;has SetMouse been called?
0627 E40A 30 09                 bmi   NoMode                   ;no
0628 E40C              ;	xba		;get slot in lo byte
0629 E40C              ;	and	#$FF	;mask off hi byte
0630 E40C              ;	tax
0631 E40C              ;	lda	>MouseMode,x	;get current mode
0632 E40C
0633 E40C AF 97 01 E1           lda   >MseMode                 ;get current mode
0634 E410 29 0F 00              and   #$F                      ;mask off all but bits 0-3
0635 E413 85 5C                 sta   <SaveMode
0636 E415
0637 E415 F4 00 00     NoMode   PushWord #0                    ;find mouse
0638 E418 A2 03 18 22           _InitMouse 
0639 E41F B0 0E                 bcs   SetClamps                ;branch if no mouse
0640 E421
0641 E421 E6 3E                 inc   <GotMouse                ;set mouse flag
0642 E423
0643 E423              ;	lda	>MouseSlot	;check slot mouse is in
0644 E423              ;	and	#$FF	;mask off hi byte
0645 E423              ;	cmp	#4	;in slot 4?
0646 E423              ;	bne	DoExt	;no - so external card
0647 E423
0648 E423              ;	longa	off
0649 E423              ;	longi	off
0650 E423              ;	sep	#%00110000	;go into 8-bit mode
0651 E423
0652 E423              ;	lda	>CardType
0653 E423
0654 E423              ;	longa	on
0655 E423              ;	longi	on
0656 E423              ;	rep	#%00110000	;go back to 16-bit mode
0657 E423
0658 E423              ;	and	#$10	;check bit 4
0659 E423              ;	bne	DoExt	;it's set so external card
0660 E423              ;			;it's clear so internal FDB mouse
0661 E423
0662 E423 F4 07 00              PushWord #7                    ;interrupt on movement and button
0663 E426 A2 03 19 22           _SetMouse                      ;turn on mouse
0664 E42D 80 00                 bra   SetClamps
0665 E42F
0666 E42F              ;DoExt	PushWord #1		;transparent mode
0667 E42F              ;	_SetMouse		;turn on mouse
0668 E42F
0669 E42F              ;	lda	#1
0670 E42F              ;	sta	<ExtMouse	;set external mouse flag
0671 E42F              ;	sta	>TaskHead+4	;set up task counter
0672 E42F              ;	lda	#TaskSig
0673 E42F              ;	sta	>TaskHead+6	;set up signature word
0674 E42F              ;	lda	#MouseTask
0675 E42F              ;	pha
0676 E42F              ;	xba		;set up JMP to MouseTask
0677 E42F              ;	and	#$FF00
0678 E42F              ;	ora	#$005C
0679 E42F              ;	sta	>TaskHead+8
0680 E42F              ;	pla
0681 E42F              ;	and	#$FF00
0682 E42F              ;	ora	#^MouseTask
0683 E42F              ;	xba
0684 E42F              ;	sta	>TaskHead+10
0685 E42F
0686 E42F              ;	PushPtr TaskHead
0687 E42F              ;	_SetHeartBeat	;install mouse task in heartbeat queue
0688 E42F
0689 E42F
0690 E42F A3 11        SetClamps lda   17,s                    ;X min
0691 E431 48                    pha   
0692 E432 8F E9 00 E1           sta   >EMXPos                  ;init X position in case no mouse
0693 E436 A3 11                 lda   17,s                     ;X max
0694 E438 38                    sec   
0695 E439 E9 01 00              sbc   #1
0696 E43C 48                    pha   
0697 E43D A3 11                 lda   17,s                     ;Y min
0698 E43F 48                    pha   
0699 E440 8F EB 00 E1           sta   >EMYPos                  ;init Y position in case no mouse
0700 E444 A3 11                 lda   17,s                     ;Y max
0701 E446 38                    sec   
0702 E447 E9 01 00              sbc   #1
0703 E44A 48                    pha   
0704 E44B A2 03 1C 22           _ClampMouse                    ;set mouse (relative device) clamps
0705 E452
0706 E452 A3 11                 lda   17,s                     ;X min
0707 E454 48                    pha   
0708 E455 A3 11                 lda   17,s                     ;X max
0709 E457 38                    sec   
0710 E458 E9 01 00              sbc   #1
0711 E45B 48                    pha   
0712 E45C A3 11                 lda   17,s                     ;Y min
0713 E45E 48                    pha   
0714 E45F A3 11                 lda   17,s                     ;Y max
0715 E461 38                    sec   
0716 E462 E9 01 00              sbc   #1
0717 E465 48                    pha   
0718 E466 A2 03 2A 22           _SetAbsClamp                   ;set absolute device clamps
0719 E46D
0720 E46D A2 03 1A 22           _HomeMouse                     ;position mouse at min clamps
0721 E474 B0 19                 bcs   Done                     ;branch if no mouse
0722 E476
0723 E476 48                    pha   
0724 E477 48                    pha   
0725 E478 48                    pha   
0726 E479 A2 03 33 22           _readMouse2                    ;set up initial values
0727 E480 68                    pla   
0728 E481 8F E7 00 E1           sta   >EMBStat
0729 E485 68                    pla   
0730 E486 8F EB 00 E1           sta   >EMYPos
0731 E48A 68                    pla   
0732 E48B 8F E9 00 E1           sta   >EMXPos
0733 E48F
0734 E48F AF E9 00 E1  Done     lda   >EMXPos
0735 E493 48                    pha   
0736 E494 AF EB 00 E1           lda   >EMYPos
0737 E498 48                    pha   
0738 E499 22 60 00 E1           jsl   CUpdate                  ;init cursor to min clamps
0739 E49D
0740 E49D A3 15                 lda   21,s                     ;get zero page address
0741 E49F F4 00 00              PushWord #0 
0742 E4A2 F4 06 00              PushWord #EMTSNum 
0743 E4A5 F4 00 00              PushWord #0 
0744 E4A8 48                    pha   
0745 E4A9 A2 01 0D 22           _SetWAP                        ;set work area pointer
0746 E4B0
0747 E4B0 20 31 E7              jsr   DoLoadKTrans             ; added 1/22/89 and 2/13/89!
0748 E4B3
0749 E4B3 58                    cli                            ;enable interrupts
0750 E4B4 4C 7C FC              jmp   EndCall14
0751 E4B7                       ENDP 
0752 E4B7
0753 E4B7
0754 E4B7
0755 E4B7              ****************************************************************
0756 E4B7              *
0757 E4B7              * EMShutDown
0758 E4B7              *
0759 E4B7              ****************************************************************
0760 E4B7
0761 E4B7                       EXPORT EMShutDown 
0762 E4B7              EMShutDown PROC 
0763 E4B7
0764 E4B7 0B                    phd   
0765 E4B8 5B                    tcd   
0766 E4B9 D0 06                 bne   Doit
0767 E4BB A2 03 06              ldx   #ActiveErr               ;return error if EM not active
0768 E4BE 4C E3 FB              jmp   ErrOut0
0769 E4C1
0770 E4C1 78           Doit     sei                            ;turn off  interrupts
0771 E4C2
0772 E4C2 F4 E1 00              pea   TaskHead>>16
0773 E4C5 F4 ED 00              pea   TaskHead**$FFFF
0774 E4C8 A2 03 13 22           _DelHeartBeat                  ;remove mouse task from heartbeat Q
0775 E4CF
0776 E4CF A5 56                 lda   <KBufOn                  ;was keyboard buffering on before init?
0777 E4D1 D0 13                 bne   Cont                     ;yes - so don't turn off
0778 E4D3 F4 01 00              PushWord #1                    ;# of data bytes
0779 E4D6 F4 FE 00 F4           PushPtr FDBData                ;push address of data byte
0780 E4DC F4 05 00              PushWord #5                    ;mode cmd
0781 E4DF A2 09 09 22           _SendInfo                      ; (_FDBCmd)  ;disable keyboard buffering
0782 E4E6
0783 E4E6 A5 5A        Cont     lda   <VBLOn                   ;were VBL interrupts on before init?
0784 E4E8 D0 0A                 bne   Cont1                    ;yes - so don't turn off
0785 E4EA F4 03 00              PushWord #3                    ;disable VBL interrupts
0786 E4ED A2 03 23 22           _IntSource 
0787 E4F4
0788 E4F4 A5 58        Cont1    lda   <KBOn                    ;were keyboard interrupts on
0789 E4F6 D0 0A                 bne   Cont2                    ;yes - so don't turn off
0790 E4F8 F4 01 00              PushWord #1                    ;disable keyboard interrupts
0791 E4FB A2 03 23 22           _IntSource 
0792 E502
0793 E502 A5 3E        Cont2    lda   <GotMouse                ;is mouse present?
0794 E504 F0 0A                 beq   Cont3                    ;no
0795 E506 A5 5C                 lda   <SaveMode                ;yes - so set mouse mode back to
0796 E508 48                    pha                            ;original value
0797 E509 A2 03 19 22           _SetMouse 
0798 E510              ;                                       ;restore original interrupt vectors
0799 E510 F4 0D 00     Cont3    PushWord #$0D 
0800 E513 A5 44 48 A5           PushLong <MouseAdrs            ;mouse
0801 E519 22 31 13 FE           jsl   SetVectorGlue
0802 E51D F4 0F 00              PushWord #$0F 
0803 E520 A5 48 48 A5           PushLong <KBAdrs               ;keyboard
0804 E526 22 31 13 FE           jsl   SetVectorGlue
0805 E52A F4 12 00              PushWord #$12 
0806 E52D A5 4C 48 A5           PushLong <DAAdrs               ;desk accessory
0807 E533 22 31 13 FE           jsl   SetVectorGlue
0808 E537 F4 13 00              PushWord #$13 
0809 E53A A5 50 48 A5           PushLong <FBAdrs               ;flush buffer
0810 E540 22 31 13 FE           jsl   SetVectorGlue
0811 E544 F4 0C 00              PushWord #$0C 
0812 E547 A5 54 48 A5           PushLong <VBLAdrs              ;VBL
0813 E54D 22 31 13 FE           jsl   SetVectorGlue
0814 E551
0815 E551 A5 26                 lda   <QHandle+2               ;release queue space
0816 E553 48                    pha   
0817 E554 A5 24                 lda   <QHandle
0818 E556 48                    pha   
0819 E557 A2 02 10 22           _DisposeHandle 
0820 E55E
0821 E55E              ; dump the keytrans table that we loaded to start with ...
0822 E55E 48                    pha                            ; room for result
0823 E55F A9 5A 00              lda   #kTransBParamLoc
0824 E562 48                    pha   
0825 E563 A2 03 0C 22           _ReadBParam                    ; get our parameter
0826 E56A 68                    pla   
0827 E56B F0 15                 beq   DDKTDone                 ; if zero, then bag it!
0828 E56D 29 FF 00              and   #$00FF
0829 E570 09 00 06              ora   #$0600                   ; add event mgr ID
0830 E573 AA                    tax                            ; save it in <X> for a seconf...
0831 E574
0832 E574 F4 21 80              pea   $8021                    ; ktrans resource type
0833 E577 F4 FF 0F              pea   $0FFF                    ; resource ID
0834 E57A              ; create the low byte of the ID here!
0835 E57A DA                    phx                            ; event manager resource #1
0836 E57B A2 03 36 22           _ReleaseRomResource            ; now call releaseROMResource
0837 E582              DDKTDone  
0838 E582 F4 00 00              PushWord #0 
0839 E585 F4 06 00              PushWord #EMTSNum 
0840 E588 F4 00 00              PushWord #0 
0841 E58B F4 00 00              PushWord #0 
0842 E58E A2 01 0D 22           _SetWAP                        ;clear work area pointer
0843 E595
0844 E595 A5 5E                 lda   <SaveP
0845 E597 48                    pha   
0846 E598 28                    plp   
0847 E599 28                    plp                            ;restore original processor status
0848 E59A
0849 E59A 4C E0 FB              jmp   EndCall0
0850 E59D
0851 E59D                       ENDP 
0852 E59D
0853 E59D
0854 E59D
0855 E59D              ****************************************************************
0856 E59D              *
0857 E59D              * EMVersion
0858 E59D              *
0859 E59D              ****************************************************************
0860 E59D
0861 E59D                       EXPORT EMVersion 
0862 E59D              EMVersion PROC 
0863 E59D A9 00 03              lda   #EMVerNum
0864 E5A0 83 07                 sta   7,s
0865 E5A2 4C DF FB              jmp   oEndCall0
0866 E5A5                       ENDP 
0867 E5A5
0868 E5A5
0869 E5A5              ****************************************************************
0870 E5A5              *
0871 E5A5              * EMReset
0872 E5A5              *
0873 E5A5              ****************************************************************
0874 E5A5
0875 E5A5                       EXPORT EMReset 
0876 E5A5              EMReset  PROC 
0877 E5A5 C9 00 00              cmp   #0                       ;is EM active?
0878 E5A8 F0 06                 beq   Done                     ;no
0879 E5AA A2 02 06              ldx   #ResetErr                ;yes - so return error
0880 E5AD 4C E4 FB              jmp   oErrOut0
0881 E5B0
0882 E5B0 4C DF FB     Done     jmp   oEndCall0
0883 E5B3                       ENDP 
0884 E5B3
0885 E5B3
0886 E5B3              ****************************************************************
0887 E5B3              *
0888 E5B3              * EMActive
0889 E5B3              *
0890 E5B3              ****************************************************************
0891 E5B3
0892 E5B3                       EXPORT EMActive 
0893 E5B3              EMActive PROC 
0894 E5B3 83 07                 sta   7,s
0895 E5B5 4C DF FB              jmp   oEndCall0
0896 E5B8                       ENDP 
0897 E5B8
0898 E5B8              ;                APPEND tbem
0899 E5B8
0900 E5B8
0901 E5B8
0902 E5B8              ****************************************************************
0903 E5B8              *
0904 E5B8              * DoWindows
0905 E5B8              *
0906 E5B8              ****************************************************************
0907 E5B8
0908 E5B8                       EXPORT DoWindows 
0909 E5B8              DoWindows PROC 
0910 E5B8 0B                    phd   
0911 E5B9 5B                    tcd   
0912 E5BA D0 06                 bne   Doit
0913 E5BC A2 03 06              ldx   #ActiveErr               ;EM not active
0914 E5BF 4C E3 FB              jmp   ErrOut0
0915 E5C2
0916 E5C2 83 09        Doit     sta   9,s                      ;return Event Mgr's zero page reg
0917 E5C4 A9 01 00              lda   #1
0918 E5C7 85 38                 sta   <WindowMgr               ;set flag
0919 E5C9 4C E0 FB              jmp   EndCall0
0920 E5CC                       ENDP 
0921 E5CC
0922 E5CC
0923 E5CC
0924 E5CC              ****************************************************************
0925 E5CC              *
0926 E5CC              * GetNextEvent
0927 E5CC              *
0928 E5CC              ****************************************************************
0929 E5CC
0930 E5CC                       EXPORT GetNextEvent 
0931 E5CC              GetNextEvent PROC 
0932 E5CC 0B                    phd   
0933 E5CD 5B                    tcd   
0934 E5CE D0 06                 bne   Doit
0935 E5D0 A2 03 06              ldx   #ActiveErr               ;EM not active
0936 E5D3 4C 27 FC              jmp   ErrOut6
0937 E5D6
0938 E5D6 E6 3A        Doit     inc   <RemoveEvent
0939 E5D8
0940 E5D8                       EXPORT GNECommon 
0941 E5D8              GNECommon                               ;       
0942 E5D8 A3 09                 lda   9,s                      ;move event ptr onto zero page
0943 E5DA 85 10                 sta   <UserEvtPtr
0944 E5DC A3 0B                 lda   11,s
0945 E5DE 85 12                 sta   <UserEvtPtr+2
0946 E5E0 20 36 E6              jsr   GetNullEvent             ;get a null event record
0947 E5E3 20 3D E6              jsr   CheckActivate            ;check for activate event
0948 E5E6 D0 24                 bne   GotEvent
0949 E5E8 20 A7 E6              jsr   CheckSwitch              ;check for switch event
0950 E5EB D0 1F                 bne   GotEvent
0951 E5ED 20 C8 E6              jsr   CheckQueue               ;check event queue
0952 E5F0 D0 1A                 bne   GotEvent
0953 E5F2 20 E8 E6              jsr   CheckUpdate              ;check for update event
0954 E5F5 D0 15                 bne   GotEvent
0955 E5F7 AF E1 00 E1           lda   >JournalFlag             ;journaling on?
0956 E5FB F0 32                 beq   Done                     ;no
0957 E5FD F4 00 00              PushWord #0                    ;push address of TempEvent
0958 E600 18                    clc                            ;so GetMouse will have a place to
0959 E601 7B                    tdc                            ;store its result
0960 E602 69 00 00              adc   #TempEvent
0961 E605 48                    pha   
0962 E606 22 1F E7 FE           jsl   xGetMouse                ;read mouse so it will be journalled
0963 E60A 80 1B                 bra   RetFalse                 ;return a null event
0964 E60C
0965 E60C              GotEvent  
0966 E60C A5 3A                 lda   <RemoveEvent             ;EventAvail call?
0967 E60E F0 1C                 beq   RetTrue                  ;yes - so don't call Desk Mgr
0968 E610 F4 00 00              PushWord #0                    ;push result
0969 E613 A0 0E 00              ldy   #EvtSize-2               ;push event on stack
0970 E616 B7 10        Loop     lda   [<UserEvtPtr],y
0971 E618 48                    pha   
0972 E619 88                    dey   
0973 E61A 88                    dey   
0974 E61B 10 F9                 bpl   Loop
0975 E61D A2 05 1A 22           _SystemEvent                   ;call Desk Mgr
0976 E624 68                    pla                            ;did system grab event?
0977 E625 F0 05                 beq   RetTrue                  ;no
0978 E627 A9 00 00     RetFalse lda   #False                   ;yes
0979 E62A 80 03                 bra   Done
0980 E62C
0981 E62C A9 01 00     RetTrue  lda   #True
0982 E62F 83 0F        Done     sta   15,s
0983 E631 64 3A                 stz   <RemoveEvent
0984 E633 4C 24 FC              jmp   EndCall6
0985 E636
0986 E636              *------------------------------------------------------------------------------
0987 E636
0988 E636 A9 00 00     GetNullEvent lda   #0                   ;mask out all events
0989 E639 20 05 E7              jsr   GetEvent
0990 E63C 60                    rts   
0991 E63D
0992 E63D              *-------------------------------------------------------------------------------
0993 E63D
0994 E63D A3 0F        CheckActivate lda   15,s                ;get event mask
0995 E63F 29 00 01              and   #BActivate               ;activate event enabled?
0996 E642 F0 51                 beq   ADone                    ;no - so return false
0997 E644 A5 82                 lda   <FlgDeActive             ;see if deactive event pending
0998 E646 D0 4E                 bne   GotDeActive              ;got one
0999 E648 A5 80                 lda   <FlgActive               ;see if activate event pending
1000 E64A F0 49                 beq   ADone                    ;none so return false
1001 E64C A0 02 00              ldy   #MsgOffset
1002 E64F A5 84                 lda   <CurActive               ;move window pointer into event msg
1003 E651 97 10                 sta   [<UserEvtPtr],y
1004 E653 C8                    iny   
1005 E654 C8                    iny   
1006 E655 A5 86                 lda   <CurActive+2
1007 E657 97 10                 sta   [<UserEvtPtr],y
1008 E659 A9 01 00              lda   #1
1009 E65C 85 20                 sta   <TempBits                ;set activate flag
1010 E65E A5 88        GotActCommon lda   <CurDeActive         ;get deactivated window
1011 E660 F0 14                 beq   Q1                       ;branch if none
1012 E662 A5 84                 lda   <CurActive               ;get active window
1013 E664 F0 10                 beq   Q1                       ;branch if none
1014 E666 A0 04 00              ldy   #KindOffset
1015 E669 B7 84                 lda   [<CurActive],y           ;get WindowKind
1016 E66B 45 8C                 eor   <CurDeKind               ;did hi bit change?
1017 E66D 10 07                 bpl   Q1                       ;no
1018 E66F A5 20                 lda   <Tempbits
1019 E671 09 02 00              ora   #2                       ;set change flag
1020 E674 85 20                 sta   <TempBits
1021 E676 A0 0E 00     Q1       ldy   #ModsOffset
1022 E679 B7 10                 lda   [<UserEvtPtr],y          ;get modifiers field
1023 E67B 05 20                 ora   <TempBits                ;or in flag bits
1024 E67D 97 10                 sta   [<UserEvtPtr],y          ;put it back
1025 E67F A5 3A                 lda   <RemoveEvent             ;EventAvail call?
1026 E681 F0 0A                 beq   ACont                    ;yes - so don't clear flags
1027 E683 A5 82                 lda   <FlgDeActive             ;deactivate event?
1028 E685 F0 04                 beq   ClearActive              ;no - so must be activate event
1029 E687 64 82                 stz   <FlgDeActive             ;clear deactivate flag
1030 E689 80 02                 bra   ACont
1031 E68B
1032 E68B 64 80        ClearActive stz   <FlgActive            ;clear activate flag
1033 E68D A9 08 00     ACont    lda   #Activate
1034 E690 87 10                 sta   [<UserEvtPtr]            ;event code
1035 E692 A9 01 00              lda   #True
1036 E695 60           ADone    rts   
1037 E696
1038 E696 64 20        GotDeActive stz   <TempBits             ;clear the activate flag
1039 E698 A0 02 00              ldy   #MsgOffset
1040 E69B A5 88                 lda   <CurDeActive             ;move window pointer into event msg
1041 E69D 97 10                 sta   [<UserEvtPtr],y
1042 E69F C8                    iny   
1043 E6A0 C8                    iny   
1044 E6A1 A5 8A                 lda   <CurDeActive+2
1045 E6A3 97 10                 sta   [<UserEvtPtr],y
1046 E6A5 80 B7                 bra   GotActCommon
1047 E6A7
1048 E6A7              *-------------------------------------------------------------------------------
1049 E6A7
1050 E6A7 A3 0F        CheckSwitch lda   15,s                  ;get event mask
1051 E6A9 29 00 02              and   #BSwitch                 ;switch event enabled?
1052 E6AC F0 19                 beq   SDone                    ;no
1053 E6AE A5 36                 lda   <GotSwitchCall           ;switch call received?
1054 E6B0 F0 15                 beq   SDone                    ;no - so return false
1055 E6B2 A3 0F                 lda   15,s                     ;get event mask
1056 E6B4 20 EA E6              jsr   UCont                    ;check for pending update events
1057 E6B7 D0 0E                 bne   SDone                    ;got one so return it
1058 E6B9 A5 3A                 lda   <RemoveEvent             ;EventAvail call?
1059 E6BB F0 02                 beq   SCont                    ;yes - so don't clear flag
1060 E6BD 64 36                 stz   <GotSwitchCall           ;clear switch flag
1061 E6BF A9 09 00     SCont    lda   #Switch                  ;no update events so return switch event
1062 E6C2 87 10                 sta   [<UserEvtPtr]
1063 E6C4 A9 01 00              lda   #True
1064 E6C7 60           SDone    rts   
1065 E6C8
1066 E6C8              *-------------------------------------------------------------------------------
1067 E6C8
1068 E6C8 E6 62        CheckQueue inc   <FromGNE
1069 E6CA A3 0F                 lda   15,s                     ;get event mask
1070 E6CC 20 05 E7              jsr   GetEvent
1071 E6CF 64 62                 stz   <FromGNE                 ;clear flag
1072 E6D1 AF E1 00 E1           lda   >JournalFlag             ;journaling on?
1073 E6D5 F0 0E                 beq   QDone                    ;no
1074 E6D7 A5 10                 lda   <UserEvtPtr              ;move user's event pointer into
1075 E6D9 85 14                 sta   <JResultPtr              ;journal result pointer
1076 E6DB A5 12                 lda   <UserEvtPtr+2
1077 E6DD 85 16                 sta   <JResultPtr+2
1078 E6DF A2 04 00              ldx   #JcEvent                 ;journal code
1079 E6E2 20 86 EC              jsr   DoJournal
1080 E6E5 A7 10        QDone    lda   [<UserEvtPtr]            ;get event code - 0 if no event
1081 E6E7 60                    rts   
1082 E6E8
1083 E6E8              *-------------------------------------------------------------------------------
1084 E6E8
1085 E6E8 A3 0F        CheckUpdate lda   15,s                  ;get event mask
1086 E6EA 29 40 00     UCont    and   #BUpdate                 ;update event enabled?
1087 E6ED F0 15                 beq   UDone                    ;no - so return false
1088 E6EF A5 38                 lda   <WindowMgr               ;is Window Mgr initialized?
1089 E6F1 F0 11                 beq   UDone                    ;no - so return false
1090 E6F3 F4 00 00              PushWord #0                    ;push result
1091 E6F6 A5 12 48 A5           PushLong <UserEvtPtr           ;push event ptr
1092 E6FC A2 0E 0A 22           _CheckUpdate                   ;call Window Mgr
1093 E703 68                    pla                            ;get result
1094 E704 60           UDone    rts   
1095 E705
1096 E705              *------------------------------------------------------------------------------
1097 E705
1098 E705 F4 00 00     GetEvent PushWord #0                    ;push result
1099 E708 48                    pha                            ;push event mask
1100 E709 A5 12 48 A5           PushLong <UserEvtPtr           ;push event ptr
1101 E70F A5 3A                 lda   <RemoveEvent             ;EventAvail call?
1102 E711 F0 06                 beq   Peek                     ;yes
1103 E713 22 25 E7 FE           jsl   xGetOSEvent
1104 E717 80 04                 bra   GDone
1105 E719 22 2B E7 FE  Peek     jsl   xOSEventAvail
1106 E71D 68           GDone    pla                            ;pull result
1107 E71E 60                    rts   
1108 E71F
1109 E71F              *------------------------------------------------------------------------------
1110 E71F
1111 E71F 7B           xGetMouse tdc   
1112 E720 22 4F E7 FE           jsl   GetMouse
1113 E724 6B                    rtl   
1114 E725
1115 E725 7B           xGetOSEvent tdc   
1116 E726 22 15 EA FE           jsl   GetOSEvent
1117 E72A 6B                    rtl   
1118 E72B
1119 E72B 7B           xOSEventAvail tdc   
1120 E72C 22 DC EA FE           jsl   OSEventAvail
1121 E730 6B                    rtl   
1122 E731
1123 E731                       Entry DoLoadKTrans 
1124 E731              DoLoadKTrans  
1125 E731              ; This should be called by our startup routine to load the keytrans table to start
1126 E731
1127 E731 64 66                 stz   <ktransRef
1128 E733 64 68                 stz   <ktransRef+2
1129 E735 64 6A                 stz   <kTransFlag
1130 E737
1131 E737 F4 FF FF              pea   $FFFF                    ; special setktrans flag
1132 E73A A2 06 1C 22           _SetKeyTranslation 
1133 E741
1134 E741 60           DLKTDone rts                            ; and leave...
1135 E742                       ENDP 
1136 E742
1137 E742
1138 E742
1139 E742              ****************************************************************
1140 E742              *
1141 E742              * EventAvail
1142 E742              *
1143 E742              ****************************************************************
1144 E742
1145 E742                       EXPORT EventAvail 
1146 E742              EventAvail PROC 
1147 E742 0B                    phd   
1148 E743 5B                    tcd   
1149 E744 D0 06                 bne   Doit
1150 E746 A2 03 06              ldx   #ActiveErr               ;EM not active
1151 E749 4C 27 FC              jmp   ErrOut6
1152 E74C
1153 E74C 4C D8 E5     Doit     jmp   GNECommon
1154 E74F                       ENDP 
1155 E74F
1156 E74F
1157 E74F
1158 E74F              ****************************************************************
1159 E74F              *
1160 E74F              * GetMouse
1161 E74F              *
1162 E74F              ****************************************************************
1163 E74F
1164 E74F                       EXPORT GetMouse 
1165 E74F              GetMouse PROC 
1166 E74F 0B                    phd   
1167 E750 5B                    tcd   
1168 E751 D0 06                 bne   Doit
1169 E753 A2 03 06              ldx   #ActiveErr               ;EM not active
1170 E756 4C 11 FC              jmp   ErrOut4
1171 E759
1172 E759 08           Doit     php   
1173 E75A 78                    sei   
1174 E75B A3 0A                 lda   10,s                     ;put user's pointer on zero page
1175 E75D 85 1C                 sta   <TempPtr
1176 E75F A3 0C                 lda   12,s
1177 E761 85 1E                 sta   <TempPtr+2
1178 E763 A0 00 00              ldy   #0
1179 E766 20 37 EC              jsr   GetGlobalLoc             ;get mouse loc in global coordinates
1180 E769 AF E1 00 E1           lda   >JournalFlag             ;journaling on?
1181 E76D F0 0E                 beq   Cont                     ;no
1182 E76F A5 1C                 lda   <TempPtr                 ;move user's result pointer into
1183 E771 85 14                 sta   <JResultPtr              ;journal result pointer
1184 E773 A5 1E                 lda   <TempPtr+2
1185 E775 85 16                 sta   <JResultPtr+2
1186 E777 A2 01 00              ldx   #JcGetMouse              ;journal code
1187 E77A 20 86 EC              jsr   DoJournal
1188 E77D A5 1E 48 A5  Cont     PushLong <TempPtr              ;push user's result pointer on stack
1189 E783 A2 04 85 22           _GlobalToLocal                 ;call QuickDraw to map to local coords
1190 E78A 28                    plp   
1191 E78B 4C 0E FC              jmp   EndCall4
1192 E78E                       ENDP 
1193 E78E
1194 E78E
1195 E78E
1196 E78E              ****************************************************************
1197 E78E              *
1198 E78E              * Button
1199 E78E              *
1200 E78E              ****************************************************************
1201 E78E
1202 E78E                       EXPORT Button 
1203 E78E              Button   PROC 
1204 E78E 0B                    phd   
1205 E78F 5B                    tcd   
1206 E790 D0 06                 bne   Doit
1207 E792 A2 03 06              ldx   #ActiveErr               ;EM not active
1208 E795 4C FB FB              jmp   ErrOut2
1209 E798
1210 E798 A3 09        Doit     lda   9,s                      ;get button #
1211 E79A C9 02 00              cmp   #2
1212 E79D 90 06                 bcc   Cont
1213 E79F A2 05 06              ldx   #BtnErr                  ;illegal button #
1214 E7A2 4C FB FB              jmp   ErrOut2
1215 E7A5
1216 E7A5 0A           Cont     asl   a
1217 E7A6 AA                    tax   
1218 E7A7 AF E7 00 E1           lda   >EMBStat                 ;get status byte
1219 E7AB 3F 43 E2 FE           and   >BStatMask,x             ;mask off correct button bit
1220 E7AF F0 03                 beq   Return                   ;button up so return false
1221 E7B1 A9 01 00              lda   #True                    ;button down so return true
1222 E7B4 83 0B        Return   sta   11,s                     ;return result
1223 E7B6 AF E1 00 E1           lda   >JournalFlag             ;journaling on?
1224 E7BA F0 0F                 beq   Done                     ;no
1225 E7BC 64 16                 stz   <JResultPtr+2            ;set up pointer to result for journaling
1226 E7BE 18                    clc   
1227 E7BF 3B                    tsc   
1228 E7C0 69 0B 00              adc   #11
1229 E7C3 85 14                 sta   <JResultPtr
1230 E7C5 A2 02 00              ldx   #JcButton                ;journal code
1231 E7C8 20 86 EC              jsr   DoJournal
1232 E7CB 4C F8 FB     Done     jmp   EndCall2
1233 E7CE                       ENDP 
1234 E7CE
1235 E7CE
1236 E7CE
1237 E7CE              ****************************************************************
1238 E7CE              *
1239 E7CE              * StillDown
1240 E7CE              *
1241 E7CE              ****************************************************************
1242 E7CE
1243 E7CE                       EXPORT StillDown 
1244 E7CE              StillDown PROC 
1245 E7CE 0B                    phd   
1246 E7CF 5B                    tcd   
1247 E7D0 D0 06                 bne   Doit
1248 E7D2 A2 03 06              ldx   #ActiveErr               ;EM not active
1249 E7D5 4C FB FB              jmp   ErrOut2
1250 E7D8
1251 E7D8 A3 09        Doit     lda   9,s                      ;get button #
1252 E7DA C9 02 00              cmp   #2
1253 E7DD 90 06                 bcc   Cont
1254 E7DF A2 05 06              ldx   #BtnErr                  ;illegal button #
1255 E7E2 4C FB FB              jmp   ErrOut2
1256 E7E5
1257 E7E5 F4 00 00     Cont     PushWord #0                    ;push result
1258 E7E8 48                    pha                            ;push button #
1259 E7E9 22 1B E8 FE           jsl   xButton                  ;is button down?
1260 E7ED 68                    pla                            ;get result
1261 E7EE F0 26                 beq   Return                   ;button is up so return false
1262 E7F0 E6 32                 inc   <CheckButton             ;set flag for EventAvail
1263 E7F2 A3 09                 lda   9,s                      ;get button #
1264 E7F4 85 34                 sta   <WhichButton
1265 E7F6 F4 00 00              PushWord #0                    ;push result
1266 E7F9 F4 07 00              PushWord #7                    ;push mask for button events
1267 E7FC F4 00 00              PushWord #0                    ;push address of TempEvent (4 bytes)
1268 E7FF 7B                    tdc   
1269 E800 18                    clc   
1270 E801 69 00 00              adc   #TempEvent
1271 E804 48                    pha   
1272 E805 22 21 E8 FE           jsl   xEventAvail              ;check for button events
1273 E809 64 32                 stz   <CheckButton             ;clear flag
1274 E80B 68                    pla                            ;get result
1275 E80C D0 05                 bne   GotEvent
1276 E80E A9 01 00              lda   #True                    ;no button events so return true
1277 E811 80 03                 bra   Return
1278 E813
1279 E813 A9 00 00     GotEvent lda   #False                   ;got event so return false
1280 E816 83 0B        Return   sta   11,s
1281 E818 4C F8 FB              jmp   EndCall2
1282 E81B
1283 E81B 7B           xButton  tdc   
1284 E81C 22 8E E7 FE           jsl   Button
1285 E820 6B                    rtl   
1286 E821
1287 E821 7B           xEventAvail tdc   
1288 E822 22 42 E7 FE           jsl   EventAvail
1289 E826 6B                    rtl   
1290 E827
1291 E827                       ENDP 
1292 E827
1293 E827
1294 E827
1295 E827              ****************************************************************
1296 E827              *
1297 E827              * WaitMouseUp
1298 E827              *
1299 E827              ****************************************************************
1300 E827
1301 E827                       EXPORT WaitMouseUp 
1302 E827              WaitMouseUp PROC 
1303 E827 0B                    phd   
1304 E828 5B                    tcd   
1305 E829 D0 06                 bne   Doit
1306 E82B A2 03 06              ldx   #ActiveErr               ;EM not active
1307 E82E 4C FB FB              jmp   ErrOut2
1308 E831
1309 E831 A3 09        Doit     lda   9,s                      ;get button #
1310 E833 C9 02 00              cmp   #2
1311 E836 90 06                 bcc   Cont
1312 E838 A2 05 06              ldx   #BtnErr                  ;illegal button #
1313 E83B 4C FB FB              jmp   ErrOut2
1314 E83E
1315 E83E F4 00 00     Cont     PushWord #0                    ;push result
1316 E841 48                    pha   
1317 E842 22 6D E8 FE           jsl   xStillDown               ;is button still down?
1318 E846 68                    pla                            ;get result
1319 E847 D0 1F                 bne   Return                   ;button is still down so return true
1320 E849 E6 32                 inc   <CheckButton             ;set flag for GetNextEvent
1321 E84B A3 09                 lda   9,s                      ;get button #
1322 E84D 85 34                 sta   <WhichButton
1323 E84F F4 00 00              PushWord #0                    ;push result
1324 E852 F4 04 00              PushWord #4                    ;push mask for button up events only
1325 E855 F4 00 00              PushWord #0                    ;push address of TempEvent
1326 E858 7B                    tdc   
1327 E859 18                    clc   
1328 E85A 69 00 00              adc   #TempEvent
1329 E85D 48                    pha   
1330 E85E 22 73 E8 FE           jsl   xGetNextEvent            ;remove button up event
1331 E862 64 32                 stz   <CheckButton             ;clear flag
1332 E864 68                    pla                            ;get result
1333 E865 A9 00 00              lda   #False                   ;return false
1334 E868 83 0B        Return   sta   11,s
1335 E86A 4C F8 FB              jmp   EndCall2
1336 E86D
1337 E86D 7B           xStillDown tdc   
1338 E86E 22 CE E7 FE           jsl   StillDown
1339 E872 6B                    rtl   
1340 E873
1341 E873 7B           xGetNextEvent tdc   
1342 E874 22 CC E5 FE           jsl   GetNextEvent
1343 E878 6B                    rtl   
1344 E879
1345 E879                       ENDP 
1346 E879
1347 E879
1348 E879
1349 E879              ****************************************************************
1350 E879              *
1351 E879              * TickCount
1352 E879              *
1353 E879              * Change History
1354 E879              *
1355 E879              * 29 Jun 88	Steven Glass
1356 E879              *
1357 E879              * Two things were wrong here.  First the TickCnt was being 
1358 E879              * accessed with interrupts active and second, if journaling
1359 E879              * was active, the journaling code was called with the
1360 E879              * wrong direct page register.
1361 E879              *
1362 E879              * To fix this we always switch D-reg and use EndCall0 to 
1363 E879              * finish up.  We also turn interrupts off.
1364 E879              *
1365 E879              ****************************************************************
1366 E879
1367 E879                       EXPORT TickCount 
1368 E879              TickCount PROC 
1369 E879
1370 E879                       DefineStack 
1371 E879              origP    byte 
1372 E879              origD    word 
1373 E879              RTL1     block 3 
1374 E879              RTL2     block 3 
1375 E879              Result   long 
1376 E879
1377 E879 C9 00 00              cmp   #0
1378 E87C D0 06                 bne   Doit
1379 E87E A2 03 06              ldx   #ActiveErr               ;EM not active
1380 E881 4C E4 FB              jmp   oErrOut0
1381 E884
1382 E884 0B           Doit     phd                            ; save D
1383 E885 5B                    tcd   
1384 E886 08                    php                            ; save interrupt state
1385 E887 78                    sei   
1386 E888 AF DC 00 E1           lda   >TickCnt
1387 E88C 83 0A                 sta   Result,s
1388 E88E AF DE 00 E1           lda   >TickCnt+2
1389 E892 83 0C                 sta   Result+2,s
1390 E894
1391 E894 28                    plp                            ; restore interrupts now
1392 E895
1393 E895 AF E1 00 E1           lda   >JournalFlag             ;journaling on?
1394 E899 F0 0F                 beq   Done                     ;no
1395 E89B 64 16                 stz   <JResultPtr+2            ;set up pointer to result for journaling
1396 E89D 18                    clc   
1397 E89E 3B                    tsc   
1398 E89F 69 07 00              adc   #7
1399 E8A2 85 14                 sta   <JResultPtr
1400 E8A4 A2 00 00              ldx   #JcTickCount             ;journal code
1401 E8A7 20 86 EC              jsr   DoJournal
1402 E8AA
1403 E8AA 4C E0 FB     Done     jmp   EndCall0                 ; get out and restore D
1404 E8AD
1405 E8AD                       ENDP 
1406 E8AD
1407 E8AD
1408 E8AD
1409 E8AD              ****************************************************************
1410 E8AD              *
1411 E8AD              * GetDblTime
1412 E8AD              *
1413 E8AD              ****************************************************************
1414 E8AD
1415 E8AD                       EXPORT GetDblTime 
1416 E8AD              GetDblTime PROC 
1417 E8AD C9 00 00              cmp   #0
1418 E8B0 D0 06                 bne   Doit
1419 E8B2 A2 03 06              ldx   #ActiveErr               ;EM not active
1420 E8B5 4C E4 FB              jmp   oErrOut0
1421 E8B8
1422 E8B8 F4 00 00     Doit     PushWord #0                    ;result
1423 E8BB F4 2E 00              PushWord #ClickParam           ;double click param reference
1424 E8BE A2 03 0C 22           _ReadBParam                    ;read battery ram
1425 E8C5 68                    pla                            ;double click rate (0-4)
1426 E8C6 0A                    asl   a
1427 E8C7 0A                    asl   a
1428 E8C8 AA                    tax   
1429 E8C9 BF 77 E2 FE           lda   >ClickTable,x            ;translate into ticks
1430 E8CD 83 07                 sta   7,s
1431 E8CF E8                    inx   
1432 E8D0 E8                    inx   
1433 E8D1 BF 77 E2 FE           lda   >ClickTable,x
1434 E8D5 83 09                 sta   9,s
1435 E8D7 4C DF FB              jmp   oEndCall0
1436 E8DA                       ENDP 
1437 E8DA
1438 E8DA
1439 E8DA
1440 E8DA              ****************************************************************
1441 E8DA              *
1442 E8DA              * GetCaretTime
1443 E8DA              *
1444 E8DA              ****************************************************************
1445 E8DA
1446 E8DA                       EXPORT GetCaretTime 
1447 E8DA              GetCaretTime PROC 
1448 E8DA C9 00 00              cmp   #0
1449 E8DD D0 06                 bne   Doit
1450 E8DF A2 03 06              ldx   #ActiveErr               ;EM not active
1451 E8E2 4C E4 FB              jmp   oErrOut0
1452 E8E5
1453 E8E5 F4 00 00     Doit     PushWord #0                    ;result
1454 E8E8 F4 2F 00              PushWord #FlashParam           ;flash rate param reference
1455 E8EB A2 03 0C 22           _ReadBParam                    ;read battery ram
1456 E8F2 68                    pla                            ;flash rate (0-4)
1457 E8F3 0A                    asl   a
1458 E8F4 0A                    asl   a
1459 E8F5 AA                    tax   
1460 E8F6 BF 8B E2 FE           lda   >FlashTable,x            ;translate into ticks
1461 E8FA 83 07                 sta   7,s
1462 E8FC E8                    inx   
1463 E8FD E8                    inx   
1464 E8FE BF 8B E2 FE           lda   >FlashTable,x
1465 E902 83 09                 sta   9,s
1466 E904 4C DF FB              jmp   oEndCall0
1467 E907                       ENDP 
1468 E907
1469 E907
1470 E907
1471 E907              ****************************************************************
1472 E907              *
1473 E907              * SetSwitch
1474 E907              *
1475 E907              ****************************************************************
1476 E907
1477 E907                       EXPORT SetSwitch 
1478 E907              SetSwitch PROC 
1479 E907 0B                    phd   
1480 E908 5B                    tcd   
1481 E909 D0 06                 bne   Doit
1482 E90B A2 03 06              ldx   #ActiveErr               ;EM not active
1483 E90E 4C E3 FB              jmp   ErrOut0
1484 E911
1485 E911 A9 01 00     Doit     lda   #1
1486 E914 85 36                 sta   <GotSwitchCall
1487 E916 4C E0 FB              jmp   EndCall0
1488 E919                       ENDP 
1489 E919
1490 E919              ;                APPEND osem
1491 E919
1492 E919
1493 E919
1494 E919              ****************************************************************
1495 E919              *
1496 E919              * PostEvent
1497 E919              *
1498 E919              * Change History
1499 E919              *
1500 E919              * 30 Jun 88	Steven Glass & Cheryl Ewy
1501 E919              *
1502 E919              * Change made so that auto key events are only 
1503 E919              * posted if the number of elements in the queue is less than or
1504 E919              * equal to a specified limit.  The limit is set to 0 by 
1505 E919              * EMStartup and an application can change the limit by calling the
1506 E919              * new tool call SetAutoKeyLimit.
1507 E919              *
1508 E919              ****************************************************************
1509 E919
1510 E919                       EXPORT PostEvent 
1511 E919              PostEvent PROC 
1512 E919 0B                    phd   
1513 E91A 5B                    tcd   
1514 E91B D0 06                 bne   Doit
1515 E91D A2 03 06              ldx   #ActiveErr               ;EM not active
1516 E920 4C 27 FC              jmp   ErrOut6
1517 E923
1518 E923 A3 0D        Doit     lda   13,s                     ;get event code
1519 E925 C9 10 00              cmp   #16
1520 E928 90 06                 bcc   OK
1521 E92A A2 04 06              ldx   #CodeErr                 ;illegal event code
1522 E92D 4C 27 FC              jmp   ErrOut6                  ;return the error
1523 E930
1524 E930 08           OK       php   
1525 E931 78                    sei   
1526 E932 0A                    asl   a
1527 E933 AA                    tax   
1528 E934 BF 47 E2 FE           lda   >MaskTable,x             ;get bit mask for code
1529 E938 25 22                 and   <SysEventMask            ;is this event enabled?
1530 E93A D0 09                 bne   CheckAutoKey             ;yes - so check if auto-key event
1531 E93C A9 01 00     ErrRet   lda   #1                       ;no - so return an error
1532 E93F 83 10                 sta   16,s
1533 E941 28                    plp   
1534 E942 4C 24 FC              jmp   EndCall6
1535 E945
1536 E945 A3 0E        CheckAutoKey lda   14,s                 ;get event code
1537 E947 C9 05 00              cmp   #AutoKey                 ;auto-key event?
1538 E94A D0 18                 bne   GetFreeOne               ;no - so post it
1539 E94C A5 2E                 lda   <QHead                   ;is the queue empty?
1540 E94E F0 14                 beq   GetFreeOne               ;yes - so post it!
1541 E950
1542 E950 20 A0 EB              jsr   LockQ                    ; lock and deref Q
1543 E953 A2 00 00              ldx   #0                       ; count elements in queue
1544 E956 A4 2E                 ldy   <QHead                   ; start with queue head
1545 E958 E8           Loop     inx                            ; bump counter
1546 E959 B7 28                 lda   [<QPtr],y                ; get link to next element in Q
1547 E95B A8                    tay                            ; repeat till
1548 E95C D0 FA                 bne   Loop                     ; none
1549 E95E
1550 E95E E4 64                 cpx   <AutoKeyLimit            ; check limit
1551 E960 B0 DA                 bcs   ErrRet                   ; too much, return error
1552 E962 80 03                 bra   QLocked                  ; we have room, so post it
1553 E964
1554 E964
1555 E964
1556 E964 20 A0 EB     GetFreeOne jsr   LockQ
1557 E967 A0 02 00     QLocked  ldy   #EvtOffset               ;get offset to event code in element
1558 E96A A6 2C                 ldx   <QSize                   ;max # of queue elements
1559 E96C B7 28        @Loop    lda   [<QPtr],y                ;get event code of queue element
1560 E96E C9 FF FF              cmp   #$FFFF                   ;is this element free?
1561 E971 F0 11                 beq   GotFreeOne               ;yes
1562 E973 18                    clc                            ;no - so go on to next element
1563 E974 98                    tya   
1564 E975 69 12 00              adc   #EvtQSize
1565 E978 A8                    tay   
1566 E979 CA                    dex                            ;have we checked all queue elements?
1567 E97A D0 F0                 bne   @Loop                    ;no
1568 E97C              ;                                       ;yes - so remove first element in Q
1569 E97C A4 2E                 ldy   <QHead
1570 E97E B7 28                 lda   [<QPtr],y                ;move link pointer from first queue
1571 E980 85 2E                 sta   <QHead                   ;element into QHead
1572 E982 C8                    iny   
1573 E983 C8                    iny   
1574 E984 18           GotFreeOne clc                          ;construct pointer to event record part
1575 E985 98                    tya                            ;of free element
1576 E986 65 28                 adc   <QPtr
1577 E988 85 1C                 sta   <TempPtr
1578 E98A A9 00 00              lda   #0
1579 E98D 65 2A                 adc   <QPtr+2
1580 E98F 85 1E                 sta   <TempPtr+2
1581 E991 88                    dey   
1582 E992 88                    dey   
1583 E993 84 1A                 sty   <TempLink                ;save link to queue element
1584 E995 A3 0E        SetFields lda   14,s                    ;get event code
1585 E997 87 1C                 sta   [<TempPtr]               ;store it in the event record
1586 E999 A0 02 00              ldy   #MsgOffset
1587 E99C A3 0A                 lda   10,s                     ;get the event msg
1588 E99E 97 1C                 sta   [<TempPtr],y             ;store it in the event record
1589 E9A0 C8                    iny   
1590 E9A1 C8                    iny   
1591 E9A2 A3 0C                 lda   12,s
1592 E9A4 97 1C                 sta   [<TempPtr],y
1593 E9A6 20 ED EB              jsr   FillRecord               ;fill in rest of record
1594 E9A9 20 4D EB              jsr   EnQueue                  ;add record to queue
1595 E9AC 20 CC EB              jsr   UnLockQ
1596 E9AF 28                    plp                            ;restore interrupt state
1597 E9B0 A9 00 00              lda   #0
1598 E9B3 83 0F                 sta   15,s                     ;zero result code
1599 E9B5 4C 24 FC              jmp   EndCall6
1600 E9B8                       ENDP 
1601 E9B8
1602 E9B8
1603 E9B8
1604 E9B8              ****************************************************************
1605 E9B8              *
1606 E9B8              * FlushEvents
1607 E9B8              *
1608 E9B8              ****************************************************************
1609 E9B8
1610 E9B8                       EXPORT FlushEvents 
1611 E9B8              FlushEvents PROC 
1612 E9B8 0B                    phd   
1613 E9B9 5B                    tcd   
1614 E9BA D0 06                 bne   Doit
1615 E9BC A2 03 06              ldx   #ActiveErr               ;EM not active
1616 E9BF 4C 11 FC              jmp   ErrOut4
1617 E9C2
1618 E9C2 08           Doit     php                            ;save interrupt status
1619 E9C3 78                    sei                            ;turn off interrupts
1620 E9C4 20 A0 EB              jsr   LockQ
1621 E9C7 A5 2E                 lda   <QHead                   ;get link to first queue element
1622 E9C9 85 1A                 sta   <TempLink
1623 E9CB A8                    tay   
1624 E9CC F0 3E                 beq   Done                     ;if 0 then queue is empty
1625 E9CE C8           Loop     iny                            ;get offset to event part of Q element
1626 E9CF C8                    iny   
1627 E9D0 B7 28                 lda   [<QPtr],y                ;get event code
1628 E9D2 C9 10 00              cmp   #16
1629 E9D5 90 10                 bcc   OK
1630 E9D7 F4 81 06              PushWord #QError               ;illegal event code - Q trashed
1631 E9DA F4 00 00              PushWord #0 
1632 E9DD F4 00 00              PushWord #0 
1633 E9E0 A2 03 15 22           _SysFailMgr                    ;die
1634 E9E7
1635 E9E7 0A           OK       asl   a
1636 E9E8 AA                    tax   
1637 E9E9 BF 47 E2 FE           lda   >MaskTable,x             ;get bit mask for event code
1638 E9ED AA                    tax                            ;save mask in X
1639 E9EE 23 0A                 and   10,s                     ;is it in the stop mask?
1640 E9F0 D0 18                 bne   Stop                     ;yes - so stop
1641 E9F2 8A                    txa                            ;get event mask back
1642 E9F3 23 0C                 and   12,s                     ;is it in the event mask?
1643 E9F5 F0 08                 beq   Cont                     ;no
1644 E9F7 A9 FF FF              lda   #$FFFF
1645 E9FA 97 28                 sta   [<QPtr],y                ;set event code to unused
1646 E9FC 20 69 EB              jsr   DeQueue                  ;remove element from queue
1647 E9FF A4 1A        Cont     ldy   <TempLink
1648 EA01 B7 28                 lda   [<QPtr],y                ;follow link to next Q element
1649 EA03 85 1A                 sta   <TempLink
1650 EA05 A8                    tay   
1651 EA06 D0 C6                 bne   Loop                     ;continue if not end of queue
1652 EA08 80 02                 bra   Done                     ;end of queue so return 0
1653 EA0A
1654 EA0A B7 28        Stop     lda   [<QPtr],y                ;get event code back
1655 EA0C 83 0E        Done     sta   14,s                     ;store result
1656 EA0E 20 CC EB              jsr   UnLockQ
1657 EA11 28                    plp                            ;restore interrupt status
1658 EA12 4C 0E FC              jmp   EndCall4
1659 EA15                       ENDP 
1660 EA15
1661 EA15
1662 EA15
1663 EA15              ****************************************************************
1664 EA15              *
1665 EA15              * GetOSEvent
1666 EA15              *
1667 EA15              ****************************************************************
1668 EA15
1669 EA15                       EXPORT GetOSEvent 
1670 EA15              GetOSEvent PROC 
1671 EA15 0B                    phd   
1672 EA16 5B                    tcd   
1673 EA17 D0 06                 bne   Doit
1674 EA19 A2 03 06              ldx   #ActiveErr               ;EM not active
1675 EA1C 4C 27 FC              jmp   ErrOut6
1676 EA1F
1677 EA1F E6 3C        Doit     inc   <OSRemoveEvent
1678 EA21
1679 EA21                       EXPORT GOSECommon 
1680 EA21              GOSECommon                              ;       
1681 EA21 08                    php                            ;save interrupt status
1682 EA22 78                    sei                            ;turn off interrupts
1683 EA23 20 A0 EB              jsr   LockQ
1684 EA26 A3 0E                 lda   14,s                     ;get mask
1685 EA28 F0 4E                 beq   RetNull                  ;branch if mask is 0
1686 EA2A A5 2E                 lda   <QHead                   ;move link to first queue element
1687 EA2C 85 1A                 sta   <TempLink                ;into TempLink
1688 EA2E A8                    tay   
1689 EA2F F0 47                 beq   RetNull                  ;if 0 then queue is empty
1690 EA31 C8           GetEvent iny                            ;offset to event code
1691 EA32 C8                    iny   
1692 EA33 B7 28                 lda   [<QPtr],y                ;get event code of queue element
1693 EA35 C9 10 00              cmp   #16
1694 EA38 90 10                 bcc   OK
1695 EA3A F4 81 06              PushWord #QError               ;illegal event code - Q trashed
1696 EA3D F4 00 00              PushWord #0 
1697 EA40 F4 00 00              PushWord #0 
1698 EA43 A2 03 15 22           _SysFailMgr                    ;die
1699 EA4A
1700 EA4A 5A           OK       phy                            ;preserve registers.
1701 EA4B 48                    pha                            ;
1702 EA4C
1703 EA4C 68                    pla   
1704 EA4D 7A                    ply   
1705 EA4E 0A                    asl   a                        ;multiply by 2
1706 EA4F AA                    tax   
1707 EA50 BF 47 E2 FE           lda   >MaskTable,x             ;get mask corresponding to event code
1708 EA54 23 0E                 and   14,s                     ;is this event enabled?
1709 EA56 F0 17                 beq   Cont                     ;no - so continue looking
1710 EA58 A5 32                 lda   <CheckButton             ;is button number important?
1711 EA5A F0 3E                 beq   GotEvent                 ;no - so we have an OK event
1712 EA5C B7 28                 lda   [<QPtr],y                ;get event code again
1713 EA5E C9 03 00              cmp   #3                       ;is it a button up/down event?
1714 EA61 B0 37                 bcs   GotEvent                 ;no - so we have an OK event
1715 EA63 18                    clc   
1716 EA64 98                    tya   
1717 EA65 69 02 00              adc   #MsgOffset
1718 EA68 A8                    tay   
1719 EA69 B7 28                 lda   [<QPtr],y                ;get message field from event record
1720 EA6B C5 34                 cmp   <WhichButton             ;is it the correct button?
1721 EA6D F0 2B                 beq   GotEvent                 ;yes - so we have an OK event
1722 EA6F A4 1A        Cont     ldy   <TempLink
1723 EA71 B7 28                 lda   [<QPtr],y                ;follow link to next queue element
1724 EA73 85 1A                 sta   <TempLink
1725 EA75 A8                    tay   
1726 EA76 D0 B9                 bne   GetEvent                 ;branch if not end of queue
1727 EA78              ;                                       ;return null event
1728 EA78 A5 62        RetNull  lda   <FromGNE                 ;called from GetNextEvent?
1729 EA7A D0 19                 bne   RetFalse                 ;yes - so already have null event
1730 EA7C A3 0A                 lda   10,s                     ;move user's event record pointer
1731 EA7E 85 1C                 sta   <TempPtr                 ;onto zero page
1732 EA80 A3 0C                 lda   12,s
1733 EA82 85 1E                 sta   <TempPtr+2
1734 EA84 A9 00 00              lda   #0
1735 EA87 87 1C                 sta   [<TempPtr]               ;null event code
1736 EA89 A0 02 00              ldy   #MsgOffset
1737 EA8C 97 1C                 sta   [<TempPtr],y             ;zero out event msg
1738 EA8E C8                    iny   
1739 EA8F C8                    iny   
1740 EA90 97 1C                 sta   [<TempPtr],y
1741 EA92 20 ED EB              jsr   FillRecord               ;fill in rest of event record
1742 EA95 A9 00 00     RetFalse lda   #False
1743 EA98 80 37                 bra   Done                     ;return false
1744 EA9A
1745 EA9A A3 0A        GotEvent lda   10,s                     ;move user's event record pointer onto
1746 EA9C 85 10                 sta   <UserEvtPtr              ;zero page
1747 EA9E A3 0C                 lda   12,s
1748 EAA0 85 12                 sta   <UserEvtPtr+2
1749 EAA2 18                    clc   
1750 EAA3 A5 1A                 lda   <TempLink                ;create pointer to event part of
1751 EAA5 69 02 00              adc   #EvtOffset               ;queue element
1752 EAA8 65 28                 adc   <QPtr
1753 EAAA 85 1C                 sta   <TempPtr
1754 EAAC A9 00 00              lda   #0
1755 EAAF 65 2A                 adc   <QPtr+2
1756 EAB1 85 1E                 sta   <TempPtr+2
1757 EAB3
1758 EAB3 A0 0E 00              ldy   #EvtSize-2
1759 EAB6 B7 1C        Loop     lda   [<TempPtr],y             ;move event into user's event parameter
1760 EAB8 97 10                 sta   [<UserEvtPtr],y
1761 EABA 88                    dey   
1762 EABB 88                    dey   
1763 EABC 10 F8                 bpl   Loop
1764 EABE A5 3C                 lda   <OSRemoveEvent           ;OSEventAvail call?
1765 EAC0 F0 0C                 beq   RetTrue                  ;yes - so don't remove event
1766 EAC2 A9 FF FF              lda   #$FFFF                   ;no - so remove event from queue
1767 EAC5 A4 1A                 ldy   <TempLink
1768 EAC7 C8                    iny   
1769 EAC8 C8                    iny   
1770 EAC9 97 28                 sta   [<QPtr],y                ;set event code to unused
1771 EACB 20 69 EB              jsr   DeQueue                  ;remove element from queue
1772 EACE A9 01 00     RetTrue  lda   #True
1773 EAD1 83 10        Done     sta   16,s                     ;return result
1774 EAD3 64 3C                 stz   <OSRemoveEvent
1775 EAD5 20 CC EB              jsr   UnLockQ
1776 EAD8 28                    plp                            ;restore interrupt status
1777 EAD9 4C 24 FC              jmp   EndCall6
1778 EADC                       ENDP 
1779 EADC
1780 EADC
1781 EADC
1782 EADC              ****************************************************************
1783 EADC              *
1784 EADC              * OSEventAvail
1785 EADC              *
1786 EADC              ****************************************************************
1787 EADC
1788 EADC                       EXPORT OSEventAvail 
1789 EADC              OSEventAvail PROC 
1790 EADC 0B                    phd   
1791 EADD 5B                    tcd   
1792 EADE D0 06                 bne   Doit
1793 EAE0 A2 03 06              ldx   #ActiveErr               ;EM not active
1794 EAE3 4C 27 FC              jmp   ErrOut6
1795 EAE6
1796 EAE6 4C 21 EA     Doit     jmp   GOSECommon
1797 EAE9                       ENDP 
1798 EAE9
1799 EAE9
1800 EAE9
1801 EAE9              ****************************************************************
1802 EAE9              *
1803 EAE9              * SetEventMask
1804 EAE9              *
1805 EAE9              ****************************************************************
1806 EAE9
1807 EAE9                       EXPORT SetEventMask 
1808 EAE9              SetEventMask PROC 
1809 EAE9 0B                    phd   
1810 EAEA 5B                    tcd   
1811 EAEB D0 06                 bne   Doit
1812 EAED A2 03 06              ldx   #ActiveErr               ;EM not active
1813 EAF0 4C FB FB              jmp   ErrOut2
1814 EAF3
1815 EAF3 A3 09        Doit     lda   9,s
1816 EAF5 85 22                 sta   <SysEventMask
1817 EAF7 4C F8 FB              jmp   EndCall2
1818 EAFA                       ENDP 
1819 EAFA
1820 EAFA
1821 EAFA
1822 EAFA              ****************************************************************
1823 EAFA              *
1824 EAFA              * FakeMouse
1825 EAFA              *
1826 EAFA              ****************************************************************
1827 EAFA
1828 EAFA                       EXPORT FakeMouse 
1829 EAFA              FakeMouse PROC 
1830 EAFA
1831 EAFA 0B                    phd   
1832 EAFB 5B                    tcd   
1833 EAFC D0 06                 bne   Doit
1834 EAFE A2 03 06              ldx   #ActiveErr               ;EM not active
1835 EB01 4C 53 FC              jmp   ErrOut10
1836 EB04
1837 EB04 A3 09        Doit     lda   9,s                      ;get button status
1838 EB06 8F E7 00 E1           sta   >EMBStat
1839 EB0A A3 0B                 lda   11,s                     ;get Y position
1840 EB0C 8F EB 00 E1           sta   >EMYPos
1841 EB10 A3 0D                 lda   13,s                     ;get X position
1842 EB12 8F E9 00 E1           sta   >EMXPos
1843 EB16
1844 EB16              ;	lda	<ExtMouse	;external mouse?
1845 EB16              ;	bne	DoExt	;yes
1846 EB16
1847 EB16              ;	sep	#$30	;go into 8-bit mode
1848 EB16              ;	longa	off	;stuff new XY into mouse screenholes
1849 EB16              ;	longi	off
1850 EB16              ;	lda	>MouseSlot	;get slot # of mouse
1851 EB16              ;	bmi	NoMouse	;branch if no mouse
1852 EB16              ;	tax
1853 EB16              ;	lda	>EMXPos	;get lo X
1854 EB16              ;	sta	>MouXL,x
1855 EB16              ;	lda	>EMXPos+1	;get hi X
1856 EB16              ;	sta	>MouXH,x
1857 EB16              ;	lda	>EMYPos	;get lo Y
1858 EB16              ;	sta	>MouYL,x
1859 EB16              ;	lda	>EMYPos+1	;get hi Y
1860 EB16              ;	sta	>MouYH,x
1861 EB16              ;NoMouse	rep	#$30	;go back to 16-bit mode
1862 EB16              ;	longa	on
1863 EB16              ;	longi	on
1864 EB16              ;	bra	Cont
1865 EB16
1866 EB16              ;DoExt	lda	>EMXPos
1867 EB16              ;	pha
1868 EB16              ;	lda	>EMYPos
1869 EB16              ;	pha
1870 EB16              ;	_PosMouse	;position mouse at new XY
1871 EB16
1872 EB16
1873 EB16 E2 30                 sep   #$30                     ;go into 8-bit mode
1874 EB18                       longa off                      ;stuff new XY into mouse absolute position
1875 EB18                       longi off
1876 EB18 AF E9 00 E1           lda   >EMXPos                  ;get lo X
1877 EB1C 8F 90 01 E1           sta   >LowAbsx
1878 EB20 AF EA 00 E1           lda   >EMXPos+1                ;get hi X
1879 EB24 8F 92 01 E1           sta   >HighAbsx
1880 EB28 AF EB 00 E1           lda   >EMYPos                  ;get lo Y
1881 EB2C 8F 91 01 E1           sta   >LowAbsy
1882 EB30 AF EC 00 E1           lda   >EMYPos+1                ;get hi y
1883 EB34 8F 93 01 E1           sta   >HighAbsy
1884 EB38 C2 30                 rep   #$30                     ;go back into 16-bit mode
1885 EB3A                       longa on
1886 EB3A                       longi on
1887 EB3A
1888 EB3A A3 0F        Cont     lda   15,s                     ;get mod keys latch
1889 EB3C AA                    tax   
1890 EB3D A3 11                 lda   17,s                     ;get fake servemouse result
1891 EB3F 22 48 EB FE           jsl   Kludge                   ;force a return addr onto the stack so
1892 EB43              ;                                       ;mouse interrupt routine will RTL here
1893 EB43 C2 30                 rep   #$30                     ;get back into 16-bit mode since mouse
1894 EB45 4C 50 FC              jmp   EndCall10                ;interrupt routine exits in 8-bit mode
1895 EB48
1896 EB48 48           Kludge   pha                            ;push fake servemouse result
1897 EB49 DA                    phx                            ;push mod keys latch
1898 EB4A 4C EF ED              jmp   Mouse3                   ;jmp into mouse interrupt routine
1899 EB4D
1900 EB4D                       ENDP 
1901 EB4D
1902 EB4D              ;                APPEND misc
1903 EB4D
1904 EB4D
1905 EB4D
1906 EB4D              ****************************************************************
1907 EB4D              *
1908 EB4D              * EnQueue
1909 EB4D              *
1910 EB4D              ****************************************************************
1911 EB4D
1912 EB4D                       EXPORT EnQueue 
1913 EB4D              EnQueue  PROC                           ;interrupts must be off
1914 EB4D A9 00 00              lda   #0                       ;zero out link field of new element
1915 EB50 A4 1A                 ldy   <TempLink
1916 EB52 97 28                 sta   [<QPtr],y
1917 EB54 A5 2E                 lda   <QHead                   ;is queue empty?
1918 EB56 D0 08                 bne   DoInsert                 ;no - so insert element
1919 EB58 A5 1A                 lda   <TempLink                ;yes - so set QHead and QTail
1920 EB5A 85 2E                 sta   <QHead                   ;to the new element
1921 EB5C 85 30                 sta   <QTail
1922 EB5E 80 08                 bra   Done
1923 EB60
1924 EB60 A5 1A        DoInsert lda   <TempLink                ;update current last Q element
1925 EB62 A4 30                 ldy   <QTail                   ;to link to new last Q element
1926 EB64 97 28                 sta   [<QPtr],y
1927 EB66 85 30                 sta   <QTail                   ;set QTail to the new last
1928 EB68 60           Done     rts                            ;queue element
1929 EB69                       ENDP 
1930 EB69
1931 EB69
1932 EB69
1933 EB69              ****************************************************************
1934 EB69              *
1935 EB69              * DeQueue
1936 EB69              *
1937 EB69              ****************************************************************
1938 EB69
1939 EB69                       EXPORT DeQueue 
1940 EB69              DeQueue  PROC                           ;interrupts must be off
1941 EB69
1942 EB69 A5 2E                 lda   <QHead
1943 EB6B C5 1A                 cmp   <TempLink                ;are we deleting the first element?
1944 EB6D F0 0C                 beq   DeleteFirst              ;yes
1945 EB6F A8           Loop     tay   
1946 EB70 B7 28                 lda   [<QPtr],y                ;does this element link to the one we
1947 EB72 C5 1A                 cmp   <TempLink                ;want to delete?
1948 EB74 F0 18                 beq   DeleteIt                 ;yes - so delete it
1949 EB76 B7 28                 lda   [<QPtr],y                ;no - so follow link to next element
1950 EB78 D0 F5                 bne   Loop                     ;have we reached the end of the queue?
1951 EB7A 60           Done     rts   
1952 EB7B
1953 EB7B A4 1A        DeleteFirst ldy   <TempLink
1954 EB7D B7 28                 lda   [<QPtr],y                ;link QHead to element following the
1955 EB7F 85 2E                 sta   <QHead                   ;one we are deleting
1956 EB81 A5 1A                 lda   <TempLink
1957 EB83 C5 30                 cmp   <QTail                   ;was it the only element?
1958 EB85 D0 F3                 bne   Done                     ;no
1959 EB87 A9 00 00              lda   #0                       ;yes - so set QTail to 0
1960 EB8A 85 30                 sta   <QTail
1961 EB8C 80 EC                 bra   Done
1962 EB8E
1963 EB8E BB           DeleteIt tyx                            ;save link to preceeding element
1964 EB8F A4 1A                 ldy   <TempLink
1965 EB91 B7 28                 lda   [<QPtr],y                ;unlink element from chain
1966 EB93 9B                    txy   
1967 EB94 97 28                 sta   [<QPtr],y
1968 EB96 A5 1A                 lda   <TempLink
1969 EB98 C5 30                 cmp   <QTail                   ;was it the last element?
1970 EB9A D0 DE                 bne   Done                     ;no
1971 EB9C 86 30                 stx   <QTail                   ;yes - so set QTail to element
1972 EB9E 80 DA                 bra   Done                     ;predeeding the one we deleted
1973 EBA0                       ENDP 
1974 EBA0
1975 EBA0
1976 EBA0
1977 EBA0              ****************************************************************
1978 EBA0              *
1979 EBA0              * LockQ
1980 EBA0              *
1981 EBA0              ****************************************************************
1982 EBA0
1983 EBA0                       EXPORT LockQ 
1984 EBA0              LockQ    PROC 
1985 EBA0 A5 24                 lda   <QHandle
1986 EBA2 05 26                 ora   <QHandle+2               ;is Q handle 0?
1987 EBA4 D0 10                 bne   OK                       ;no
1988 EBA6 F4 82 06              PushWord #HError               ;yes - so give fatal error
1989 EBA9 F4 00 00              PushWord #0 
1990 EBAC F4 00 00              PushWord #0 
1991 EBAF A2 03 15 22           _SysFailMgr 
1992 EBB6
1993 EBB6 A0 04 00     OK       ldy   #4
1994 EBB9 B7 24                 lda   [<QHandle],y
1995 EBBB 09 00 80              ora   #$8000                   ;set locked bit in attribute word
1996 EBBE 97 24                 sta   [<QHandle],y
1997 EBC0 A0 02 00              ldy   #2
1998 EBC3 A7 24                 lda   [<QHandle]               ;dereference handle
1999 EBC5 85 28                 sta   <QPtr
2000 EBC7 B7 24                 lda   [<QHandle],y
2001 EBC9 85 2A                 sta   <QPtr+2
2002 EBCB 60                    rts   
2003 EBCC                       ENDP 
2004 EBCC
2005 EBCC
2006 EBCC
2007 EBCC              ****************************************************************
2008 EBCC              *
2009 EBCC              * UnLockQ
2010 EBCC              *
2011 EBCC              ****************************************************************
2012 EBCC
2013 EBCC                       EXPORT UnLockQ 
2014 EBCC              UnLockQ  PROC 
2015 EBCC A5 24                 lda   <QHandle
2016 EBCE 05 26                 ora   <QHandle+2               ;is Q handle 0?
2017 EBD0 D0 10                 bne   OK                       ;no
2018 EBD2 F4 82 06              PushWord #HError               ;yes - so give fatal error
2019 EBD5 F4 00 00              PushWord #0 
2020 EBD8 F4 00 00              PushWord #0 
2021 EBDB A2 03 15 22           _SysFailMgr 
2022 EBE2
2023 EBE2 A0 04 00     OK       ldy   #4
2024 EBE5 B7 24                 lda   [<QHandle],y
2025 EBE7 29 FF 7F              and   #$7FFF                   ;clear locked bit in attribute word
2026 EBEA 97 24                 sta   [<QHandle],y
2027 EBEC 60                    rts   
2028 EBED                       ENDP 
2029 EBED
2030 EBED
2031 EBED
2032 EBED              ****************************************************************
2033 EBED              *
2034 EBED              * FillRecord
2035 EBED              *
2036 EBED              ****************************************************************
2037 EBED
2038 EBED                       EXPORT FillRecord 
2039 EBED              FillRecord PROC                         ;PostEvent and GetOSEvent JSR here
2040 EBED
2041 EBED AF DC 00 E1           lda   >TickCnt                 ;get current system ticks
2042 EBF1 A0 06 00              ldy   #WhenOffset
2043 EBF4 97 1C                 sta   [<TempPtr],y
2044 EBF6 AF DE 00 E1           lda   >TickCnt+2
2045 EBFA C8                    iny   
2046 EBFB C8                    iny   
2047 EBFC 97 1C                 sta   [<TempPtr],y
2048 EBFE A0 0A 00              ldy   #WhereOffset
2049 EC01 20 37 EC              jsr   GetGlobalLoc             ;get mouse loc in global coords
2050 EC04 A7 1C                 lda   [<TempPtr]               ;get event code
2051 EC06 F0 05                 beq   NormalMods               ;branch if null event
2052 EC08 C9 06 00              cmp   #6                       ;is it a keyboard or mouse event?
2053 EC0B 90 17                 bcc   SpecialMods              ;yes - so mods are in msg
2054 EC0D
2055 EC0D                       longa off
2056 EC0D                       longi off
2057 EC0D E2 30        NormalMods sep   #%00110000             ;go into 8 bit mode
2058 EC0F AF 25 C0 00           lda   >ModLatch                ;get mod keys latch and push as hi byte
2059 EC13 48                    pha   
2060 EC14 A9 00                 lda   #0                       ;push 0 in lo byte
2061 EC16 48                    pha   
2062 EC17
2063 EC17                       longa on
2064 EC17                       longi on
2065 EC17 C2 30                 rep   #%00110000               ;go back to 16 bitmode
2066 EC19 20 46 EC              jsr   SetModBits               ;set up modifiers word in Y
2067 EC1C 68                    pla                            ;pull mod keys latch
2068 EC1D 98                    tya                            ;xfer modifiers word into A
2069 EC1E A0 0E 00              ldy   #ModsOffset
2070 EC21 97 1C                 sta   [<TempPtr],y             ;store in Modifiers field of record
2071 EC23 60                    rts   
2072 EC24
2073 EC24 A0 04 00     SpecialMods ldy   #MsgOffset+2
2074 EC27 B7 1C                 lda   [<TempPtr],y             ;modifiers are in high word of msg
2075 EC29 A0 0E 00              ldy   #ModsOffset
2076 EC2C 97 1C                 sta   [<TempPtr],y             ;store in mod field of record
2077 EC2E A9 00 00              lda   #0
2078 EC31 A0 04 00              ldy   #MsgOffset+2
2079 EC34 97 1C                 sta   [<TempPtr],y             ;zero out hi word of msg in record
2080 EC36 60                    rts   
2081 EC37                       ENDP 
2082 EC37
2083 EC37
2084 EC37
2085 EC37              ****************************************************************
2086 EC37              *
2087 EC37              * GetGlobalLoc
2088 EC37              *
2089 EC37              ****************************************************************
2090 EC37
2091 EC37                       EXPORT GetGlobalLoc 
2092 EC37              GetGlobalLoc PROC                       ;GetMouse and FillRecord JSR here
2093 EC37 AF EB 00 E1           lda   >EMYPos
2094 EC3B 97 1C                 sta   [<TempPtr],y
2095 EC3D C8                    iny   
2096 EC3E C8                    iny   
2097 EC3F AF E9 00 E1           lda   >EMXPos
2098 EC43 97 1C                 sta   [<TempPtr],y
2099 EC45 60                    rts   
2100 EC46                       ENDP 
2101 EC46
2102 EC46
2103 EC46
2104 EC46              ****************************************************************
2105 EC46              *
2106 EC46              * SetModBits
2107 EC46              *
2108 EC46              ****************************************************************
2109 EC46
2110 EC46                       EXPORT SetModBits 
2111 EC46              SetModBits PROC                         ;FillRecord, Keyboard and Mouse JSR here
2112 EC46 A0 00 00              ldy   #0
2113 EC49 A2 00 00              ldx   #0
2114 EC4C AF E7 00 E1           lda   >EMBStat                 ;get button status
2115 EC50 3F 43 E2 FE           and   >BStatMask,x             ;is button 0 up?
2116 EC54 D0 05                 bne   Button1                  ;no
2117 EC56 98                    tya                            ;yes - so set bit
2118 EC57 09 80 00              ora   #Btn0Bit
2119 EC5A A8                    tay   
2120 EC5B A2 02 00     Button1  ldx   #2
2121 EC5E AF E7 00 E1           lda   >EMBStat                 ;get button status back
2122 EC62 3F 43 E2 FE           and   >BStatMask,x             ;is button 1 up?
2123 EC66 D0 05                 bne   Keys                     ;no
2124 EC68 98                    tya                            ;yes - so set bit
2125 EC69 09 40 00              ora   #Btn1Bit
2126 EC6C A8                    tay   
2127 EC6D A2 0E 00     Keys     ldx   #14
2128 EC70 A3 03                 lda   3,s                      ;get mod keys latch
2129 EC72 48                    pha   
2130 EC73 A3 01        Loop     lda   1,s                      ;get mod keys latch
2131 EC75 0A                    asl   a                        ;shift bits out left
2132 EC76 83 01                 sta   1,s                      ;save it
2133 EC78 90 06                 bcc   Cont                     ;if the bit was set, set proper
2134 EC7A 98                    tya                            ;bit in Y
2135 EC7B 1F 67 E2 FE           ora   >ModBitTable,x
2136 EC7F A8                    tay   
2137 EC80 CA           Cont     dex   
2138 EC81 CA                    dex   
2139 EC82 10 EF                 bpl   Loop
2140 EC84 68                    pla   
2141 EC85 60                    rts                            ;return with modifier word in Y
2142 EC86                       ENDP 
2143 EC86
2144 EC86
2145 EC86
2146 EC86              ****************************************************************
2147 EC86              *
2148 EC86              * DoJournal
2149 EC86              *
2150 EC86              ****************************************************************
2151 EC86
2152 EC86                       EXPORT DoJournal 
2153 EC86              DoJournal PROC                          ;TickCount, Button, GetMouse, and
2154 EC86 AF E1 00 E1           lda   >JournalFlag             ;journaling on?
2155 EC8A F0 0C                 beq   Done                     ;no
2156 EC8C 48                    pha                            ;push journal flag
2157 EC8D DA                    phx                            ;push journal code
2158 EC8E A5 16 48 A5           PushLong <JResultPtr           ;push result pointer
2159 EC94 22 E3 00 E1           jsl   JournalPtr               ;jump to journaling code
2160 EC98 60           Done     rts   
2161 EC99                       ENDP 
2162 EC99
2163 EC99              ;                APPEND ih
2164 EC99
2165 EC99
2166 EC99
2167 EC99
2168 EC99              ****************************************************************
2169 EC99              *
2170 EC99              * Keyboard Interrupt Handler
2171 EC99              *
2172 EC99              * 1/23/89 Mensch
2173 EC99              * Added keyboard translation tables to this routine. My but this stuff
2174 EC99              * is pretty confused. Since it is so confused, I would like to present 
2175 EC99              * you with the following:
2176 EC99              *
2177 EC99              * "How does GS keyboard remapping work?"
2178 EC99              *           a play in 1 act
2179 EC99              *              By Mensch
2180 EC99              *
2181 EC99              * Players:
2182 EC99              *   KTransRef - a handle/pointer to the current keyboard translation
2183 EC99              *               table
2184 EC99              *   KTransFlag - used by the "DeadKey" skimmer
2185 EC99              *   Steve - Boss of our hero
2186 EC99              *   Hero - The guy writing and explaining this.
2187 EC99              *   Mimi - One with international scope.
2188 EC99              *
2189 EC99              *Scene 1
2190 EC99              * Steve and Mimi are in a meeting together.
2191 EC99              * Mimi 	"Steve, all the europeans hate the GS, they say
2192 EC99              *	that they can't type"
2193 EC99              * Steve	"Tough"
2194 EC99              * Mimi	"Please, help them to compute..." (touching smile)
2195 EC99              * Steve	"Ok, I will put that lazy hero on the job"
2196 EC99              *
2197 EC99              *Scene 2
2198 EC99              * Steve and Hero are busy talking about something else when
2199 EC99              * Steve	"Oh, by the way, why don't you implement keyboard
2200 EC99              *	remapping, just like the mac's got... Mimi wanted
2201 EC99              *	us to do it for europe"
2202 EC99              * Hero	"OK, I will do it. I will modify getNextEvent"
2203 EC99              * Steve	"Don't be a putz, do it in the keyboard interupt
2204 EC99              *	handler code! God do I have to think of everything?"
2205 EC99              *
2206 EC99              *Scene 3
2207 EC99              * Hero comes back with some code and a proposal after some time and 
2208 EC99              * explains to Steve how the new keymapping will work.
2209 EC99              * Steve	"Ok, run by me exactly how this ktrans stuff is 
2210 EC99              *	going to work at the highest level"
2211 EC99              * Hero	"Well, it goes something like this: When an
2212 EC99              *	EMStartup call is made, we call getROMResource
2213 EC99              *	which will give us a handle to the keytrans table
2214 EC99              *	we then store it in the kTransRef and we store
2215 EC99              *	a zero in kTransFlag. If no table exists (Not likely)
2216 EC99              *	we store a zero in kTransRef. If a Disk based
2217 EC99              *	resource exists, we load it in. Notice that the
2218 EC99              *	handle is not locked, so it must be derefed every time
2219 EC99              *	we use it!"
2220 EC99              * Steve	"Hmmm ok, sounds good. I suppose you release the resource
2221 EC99              *	when you are done with it?"
2222 EC99              * Hero	{asside to the audience}'This guy must think I am
2223 EC99              *	completely stupid!'
2224 EC99              *	{to Steve}"Certainly, I dispose of it at EMShutdown time"
2225 EC99              * Steve	"Fine, now please tell me the details of this process,
2226 EC99              *	and after you are done telling me, could you document it 
2227 EC99              *	in the code?"
2228 EC99              * Hero	"Ok, well the ktrans table is a variable sized data object
2229 EC99              *	that can be as small as 258 bytes, or as large as 768
2230 EC99              *	bytes. The first 256 bytes always contain single byte
2231 EC99              *	values that represent the character substitution array.
2232 EC99              *	when a key is pressed, the keyboard routine will use
2233 EC99              *	the ascii code of that key (notice also that if the 
2234 EC99              *	option key is pressed down, I add 128 to the value) as
2235 EC99              *	an offset into the single byte substitution array. The resulting
2236 EC99              *	value is the key code we are to return to the program.
2237 EC99              * Steve	"OK I can see how that works, now lets say that you have a
2238 EC99              *	'dead' key, you know one of those two key sequences that
2239 EC99              *	generate a single ASCII character?"
2240 EC99              * Hero	"Well, as you can see, the first thing that I do is test
2241 EC99              *	to be sure the option key was really pressed. If it was
2242 EC99              *	I then set the current key as the dead key in the kTransFlag
2243 EC99              *	and test to see if the key is a qualifying dead key if so I
2244 EC99              *	return with carry set so that the event does not get posted.
2245 EC99              *	If not, I simply return with the carry clear and the key gets
2246 EC99              *	posted"
2247 EC99              *
2248 EC99              * {Hero adjusts his chair, and starts looking a little frazeled}
2249 EC99              * Hero	"If a key is pressed after a "dead" key has been stored,
2250 EC99              *	I again find the dead key in the table and get its offset.
2251 EC99              *	once I have the proper offset I look thru the table to find
2252 EC99              *	the current key in that deadkey's modifier table. If I
2253 EC99              *	find it, I simply change the keydata to reflect the generated
2254 EC99              *	ascii code for the dead key combo. If I do not find
2255 EC99              *	the current key I post an event for the old dead key, and 
2256 EC99              *	I return to the caller so it can post the current key."
2257 EC99              * Steve	"Wow, its that easy???"
2258 EC99              * Hero	"Sure is!"
2259 EC99              * {Curtain}
2260 EC99              *---------------- End of Play --------------------
2261 EC99              * Authors Notes:
2262 EC99              * Directors:
2263 EC99              * Please include the following description in the playbill for this program so
2264 EC99              * the patrons will have an easier time following the show!
2265 EC99              *
2266 EC99              * kTransData structure:
2267 EC99              *  Sub_Array:Packed array[0..255] of char;
2268 EC99              *  Dead_KeyArray:Packed array[0..xx] of DeadKeyStruct; (must end in a NIL word)
2269 EC99              *  ModTables:Packed array[0..xx,0..yy] of ModifierWord; (Must end in NIL word)
2270 EC99              *  end;
2271 EC99              *
2272 EC99              * DeadKeyStructure:
2273 EC99              *   Byte - keycode from Sub_Array;
2274 EC99              *   Byte - Offset/2 from end of Sub_Array to proper ModTable for this keycode
2275 EC99              *
2276 EC99              * ModifierWord:
2277 EC99              *   Byte - keycode from Sub_Array;
2278 EC99              *   Byte - keycode for this deadKeyCombo;
2279 EC99              *
2280 EC99              * NOTE: xx is the number of dead keys; yy is the number of keys each dead key
2281 EC99              * modifies.
2282 EC99              *
2283 EC99              ****************************************************************
2284 EC99
2285 EC99                       EXPORT Keyboard 
2286 EC99              Keyboard PROC 
2287 EC99                       longa off
2288 EC99                       longi off
2289 EC99 A9 00                 lda   #0
2290 EC9B 48                    pha                            ;store 0 as hi byte of keypress
2291 EC9C AF 00 C0 00           lda   >KeyLatch                ;get keypress
2292 ECA0 29 7F                 and   #$7F                     ;clear hi bit
2293 ECA2 48                    pha                            ;store in lo byte
2294 ECA3 AF 25 C0 00           lda   >ModLatch
2295 ECA7 48                    pha                            ;push mod keys latch
2296 ECA8 A9 00                 lda   #0
2297 ECAA 48                    pha                            ;push 0 as lo byte of mod keys latch
2298 ECAB 8F 10 C0 00           sta   >KbdStrobe               ;clear keyboard strobe
2299 ECAF
2300 ECAF                       longa on
2301 ECAF                       longi on
2302 ECAF C2 30                 rep   #$30                     ;go into 16 bit mode
2303 ECB1 20 46 EC              jsr   SetModBits               ;set up modifiers word in Y
2304 ECB4 68                    pla                            ;pull mod keys latch
2305 ECB5 FA                    plx                            ;pull keypress
2306 ECB6 F4 00 00              PushWord #0                    ;push result
2307 ECB9 29 00 08              and   #RepeatBit               ;was repeat bit in mod latch set?
2308 ECBC D0 05                 bne   Repeat                   ;no - so push code for KeyDown event
2309 ECBE F4 03 00              PushWord #KeyDown 
2310 ECC1 80 03                 bra   Cont
2311 ECC3
2312 ECC3 F4 05 00     Repeat   PushWord #AutoKey              ;yes - so push code for AutoKey event
2313 ECC6 5A           Cont     phy                            ;push modifiers - hi word of message
2314 ECC7 DA                    phx                            ;push keypress - lo word of message
2315 ECC8 20 DF EC              jsr   DoKTrans                 ; remap the key as needed
2316 ECCB B0 0C                 bcs   BadKey                   ; if carry set, don't post the key, pull it off and end
2317 ECCD A2 06 14 22           _PostEvent 
2318 ECD4 68                    pla                            ;pull result
2319 ECD5 E2 30        cont0010 sep   #$30                     ;go back to 8 bit mode
2320 ECD7                       longa off
2321 ECD7                       longi off
2322 ECD7 18                    clc   
2323 ECD8 6B                    rtl   
2324 ECD9
2325 ECD9                       longa on
2326 ECD9                       longi on
2327 ECD9              BadKey    
2328 ECD9 68                    pla                            ; discard the data we just pushed on the stack...
2329 ECDA 68                    pla   
2330 ECDB 68                    pla   
2331 ECDC 68                    pla   
2332 ECDD 80 F6                 bra   cont0010
2333 ECDF
2334 ECDF              *-------------------------------------------------------------------------------
2335 ECDF              ; This routine will modify the keycode and modifiers on the stack to support other
2336 ECDF              ; keyboard mapping schemes. 1/22/89
2337 ECDF              ;
2338 ECDF              DoKTrans  
2339 ECDF              ; test to see if we have a handle installed.
2340 ECDF              temp     equ   1
2341 ECDF              saveDPageRTS equ   temp+4
2342 ECDF              KeyData  equ   saveDPageRTS+4
2343 ECDF              keyMods  equ   keyData+2
2344 ECDF              theWAPT  equ   $E103C8                  ; wapt table reference
2345 ECDF
2346 ECDF 0B                    phd                            ; save the direct page
2347 ECE0 AF CA 03 E1           lda   >theWapt+2               ; dereference the work area ptr table...
2348 ECE4 48                    pha   
2349 ECE5 AF C8 03 E1           lda   >theWapt
2350 ECE9 48                    pha   
2351 ECEA 3B                    tsc   
2352 ECEB 5B                    tcd   
2353 ECEC A0 18 00              ldy   #24
2354 ECEF B7 01                 lda   [<1],y                   ; get the event manager wap
2355 ECF1 7A                    ply                            ; remove the handle deref
2356 ECF2 7A                    ply   
2357 ECF3 C9 00 00              cmp   #0                       ; re-assert the zero flag...
2358 ECF6 F0 27                 beq   DKTDone                  ; if zero, then event mgr not started...
2359 ECF8 5B                    tcd                            ; make it the current dpage...
2360 ECF9              ;
2361 ECF9              ; Now test to see if we should translate the reference
2362 ECF9
2363 ECF9 A5 68                 lda   <ktransRef+2             ; see if we need to translate
2364 ECFB D0 03                 bne   @1
2365 ECFD 18                    clc   
2366 ECFE 80 1F                 bra   DKTDone                  ; high word of zero means no dice
2367 ED00 D4 68        @1       pei   ktransRef+2              ; save handle
2368 ED02 D4 66                 pei   ktransRef
2369 ED04
2370 ED04 A0 02 00              ldy   #2                       ; deref in place
2371 ED07 B7 66                 lda   [ktransRef],y
2372 ED09 AA                    tax   
2373 ED0A A7 66                 lda   [ktransRef]
2374 ED0C 85 66                 sta   ktransRef
2375 ED0E 86 68                 stx   ktransRef+2
2376 ED10
2377 ED10              ;
2378 ED10              ; Translate the key
2379 ED10              ;
2380 ED10 A3 0B                 lda   keyMods,s                ; get the modifiers byte
2381 ED12 29 00 08              and   #$0800                   ; strip off the option key
2382 ED15 F0 11                 beq   DoNormalKey              ; if equal, then do a normalKey
2383 ED17 80 08                 bra   DoOptionKey
2384 ED19
2385 ED19              DModDone  
2386 ED19              ; come here when the key modification is finished.
2387 ED19 68                    pla                            ; restore the handle
2388 ED1A 85 66                 sta   ktransRef
2389 ED1C 68                    pla   
2390 ED1D 85 68                 sta   ktransRef+2
2391 ED1F              DKTDone   
2392 ED1F 2B                    pld                            ; restore the direct page...
2393 ED20 60                    rts   
2394 ED21
2395 ED21              DoOptionKey  
2396 ED21 A3 09                 lda   keyData,s                ; get the keyboard data
2397 ED23 09 80 00              ora   #$0080                   ; set the high bit
2398 ED26 80 02                 bra   DNK0010                  ; and continue
2399 ED28 A3 09        DoNormalKey lda   keyData,s
2400 ED2A              DNK0010   
2401 ED2A              ; keycode is in <A> right now...
2402 ED2A A8                    tay                            ; place it in <Y>
2403 ED2B B7 66                 lda   [<kTransRef],y           ; get the new character code
2404 ED2D 29 FF 00              and   #$00FF                   ; strip off high byte...
2405 ED30 AA                    tax                            ; and save it for a while...
2406 ED31 A5 6A                 lda   <kTransFlag              ; get the deadkey flag
2407 ED33 D0 25                 bne    DoDeadKey2              ; handle second dead key
2408 ED35
2409 ED35 98                    tya                            ; get the original code back
2410 ED36 29 80 00              and   #$0080                   ; test to see if it was an 'option' key
2411 ED39 F0 14                 beq   dnk0030                  ; if not, then simply finish up here
2412 ED3B 86 6A        @TestDead stx   <kTransFlag             ; save the keycode in the keytrans flag...
2413 ED3D A0 00 01              ldy   #256                     ; start scanning thru the deadkey table
2414 ED40 B7 66        dnk0020  lda   [<kTransRef],y           ; get the next key...
2415 ED42 29 FF 00              and   #$00FF                   ; strip off the hi byte
2416 ED45 F0 08                 beq   dnk0030                  ; if zero, then this is done...
2417 ED47 C5 6A                 cmp   <kTransFlag              ; see if it equals our key
2418 ED49 F0 0C                 beq   DoDeadKey1               ; If in the table,  then use it...
2419 ED4B C8                    iny                            ; bump Y to get the next keycode...
2420 ED4C C8                    iny   
2421 ED4D 80 F1                 bra   dnk0020                  ; go back for more!
2422 ED4F              dnk0030   
2423 ED4F 8A                    txa                            ; not a dead key so recover the flag
2424 ED50 64 6A                 stz   <kTransFlag              ; zero out the deadkeyFlag
2425 ED52 83 09                 sta   keyData,s                ; save it back where it belongs
2426 ED54 18                    clc                            ; set flag for good key!
2427 ED55 80 C2                 bra   dModDone                 ; finish the call... as if nothing happened
2428 ED57              DoDeadKey1  
2429 ED57              ; this routine is called if a new dead key has been pressed...
2430 ED57 38                    sec                            ; set flag for bad key
2431 ED58 80 BF                 bra   dModDone                 ; and finish!
2432 ED5A              DoDeadKey2  
2433 ED5A              ; This routine is called after the next keypress after a dead key.
2434 ED5A              ; First find the entry offset into the dead key table for the last dead key!
2435 ED5A
2436 ED5A A0 00 01              ldy   #256                     ; start scanning thru the deadkey table
2437 ED5D B7 66        ddk0020  lda   [<kTransRef],y           ; get the next key...
2438 ED5F 29 FF 00              and   #$00FF                   ; strip off the hi byte
2439 ED62 F0 24                 beq   ddkDone                  ; if zero, then something bad happened just pass it on...
2440 ED64 C5 6A                 cmp   <kTransFlag              ; see if it equals our key
2441 ED66 F0 04                 beq   ddk0030                  ; If in the table,  then use it...
2442 ED68 C8                    iny                            ; bump Y to get the next keycode...
2443 ED69 C8                    iny   
2444 ED6A 80 F1                 bra   ddk0020                  ; go back for more!
2445 ED6C              ddk0030   
2446 ED6C              ; we have found the number of that dead key, so now we step thru the deadkey data
2447 ED6C              ; tables one entry at a time till we find the proper key!
2448 ED6C B7 66                 lda   [<kTransRef],y           ; now get the table value back...
2449 ED6E 29 00 FF              and   #$FF00                   ; strip off the character code and just get the offset
2450 ED71 EB                    xba                            ; place the offset in the low byte
2451 ED72 0A                    asl   a                        ; multiply it by 2...
2452 ED73 18                    clc                            ; add 256 to it...
2453 ED74 69 00 01              adc   #256                     ; to get the offset into kTransTbl
2454 ED77 A8                    tay                            ; and store it in <Y>
2455 ED78 DA                    phx                            ; stow the keycode on the stack for a minute
2456 ED79              ddk0040   
2457 ED79              ; This loop will walk the table of values for the current dead key, looking for the 
2458 ED79              ; current keypress value
2459 ED79 B7 66                 lda   [<kTransRef],y           ; load in the next byte
2460 ED7B 29 FF 00              and   #$00FF                   ; strip off the low byte
2461 ED7E F0 1A                 beq   ddkNotValid              ; take this branch if we do not find the kay in the table
2462 ED80 C3 01                 cmp   1,s                      ; compare it to the key that was pressed..
2463 ED82 F0 0C                 beq   ddkValid                 ; found a valid double key combo...
2464 ED84 C8                    iny   
2465 ED85 C8                    iny   
2466 ED86 80 F1                 bra   ddk0040
2467 ED88              ddkDone   
2468 ED88              ; If we get here then the doublekey value is in <X>, simply return it!
2469 ED88 8A                    txa                            ; place the keycode in <A>
2470 ED89 83 09                 sta   keyData,s                ; save it back on the stack
2471 ED8B 64 6A                 stz   <kTransFlag              ; zero out the flag
2472 ED8D 18                    clc                            ; set the good key flag
2473 ED8E 80 89                 bra   DModDone                 ; and return
2474 ED90              ddkValid  
2475 ED90              ; We got a valid double key code,
2476 ED90 FA                    plx                            ; recover the word we stowed ion the stack
2477 ED91 B7 66                 lda   [<kTransRef],y           ; get the new keycode
2478 ED93 29 00 FF              and   #$FF00                   ; zap off the old data
2479 ED96 EB                    xba                            ; swap it!
2480 ED97 AA                    tax                            ; save it in <X>
2481 ED98 80 EE                 bra   ddkDone
2482 ED9A              ddkNotValid  
2483 ED9A              ; This routine is called when we get a keypress that was not in the table of key presses
2484 ED9A              ; This will resurect the dead key and post it, then it will post the 'Live' key..
2485 ED9A 68                    pla                            ; recover the keycode from the stack...
2486 ED9B 83 09                 sta   keyData,s                ; store the data for later posting
2487 ED9D A3 0B                 lda   keyMods,s                ; get the current modifiers...
2488 ED9F 48                    pha                            ; room for result...
2489 EDA0 F4 03 00              pea   $0003                    ; post a keydown event...
2490 EDA3 09 00 08              ora   #$0800                   ; be sure to set the option bit on modifiers...
2491 EDA6 48                    pha   
2492 EDA7 A5 6A                 lda   <kTransFlag              ; load the dead keycode
2493 EDA9 48                    pha   
2494 EDAA A2 06 14 22           _PostEvent                     ; post it as an event...
2495 EDB1 68                    pla                            ; discard the result 
2496 EDB2 64 6A                 stz   <kTransFlag              ; zero out the dead key flag
2497 EDB4 18                    clc                            ; clear the flag to denote a posting
2498 EDB5 82 61 FF     LongdModDone brl   dModDone
2499 EDB8
2500 EDB8                       ENDP 
2501 EDB8
2502 EDB8
2503 EDB8
2504 EDB8              ****************************************************************
2505 EDB8              *
2506 EDB8              * Mouse Interrupt Handler
2507 EDB8              *
2508 EDB8              ****************************************************************
2509 EDB8
2510 EDB8                       EXPORT Mouse 
2511 EDB8              Mouse    PROC 
2512 EDB8
2513 EDB8                       longa on
2514 EDB8                       longi on
2515 EDB8 C2 30                 rep   #$30                     ;go into 16 bitmode
2516 EDBA
2517 EDBA F4 00 00              PushWord #0                    ;space for result
2518 EDBD A2 03 1F 22           _ServeMouse 
2519 EDC4
2520 EDC4                       longa off
2521 EDC4                       longi off
2522 EDC4 E2 30                 sep   #$30                     ;go into 8 bit mode
2523 EDC6 AF 25 C0 00           lda   >ModLatch
2524 EDCA 48                    pha                            ;push mod keys latch
2525 EDCB A9 00                 lda   #0
2526 EDCD 48                    pha                            ;push lo byte
2527 EDCE                       longa on
2528 EDCE                       longi on
2529 EDCE C2 30                 rep   #$30                     ;go into 16 bit mode
2530 EDD0
2531 EDD0 F4 00 00              PushWord #0                    ;push 3 words for result
2532 EDD3 F4 00 00              PushWord #0 
2533 EDD6 F4 00 00              PushWord #0 
2534 EDD9 A2 03 33 22           _readMouse2 
2535 EDE0
2536 EDE0                       EXPORT Mouse2 
2537 EDE0              Mouse2                                  ;       ;MouseTask jmps here
2538 EDE0 68                    pla                            ;get button status
2539 EDE1 8F E7 00 E1           sta   >EMBStat
2540 EDE5 68                    pla                            ;get Y position
2541 EDE6 8F EB 00 E1           sta   >EMYPos
2542 EDEA 68                    pla                            ;get X position
2543 EDEB 8F E9 00 E1           sta   >EMXPos
2544 EDEF              ;                                       ;modlatch and servemouse result on stack
2545 EDEF                       EXPORT Mouse3 
2546 EDEF              Mouse3                                  ;       ;FakeMouse jmps here
2547 EDEF AF E9 00 E1           lda   >EMXPos
2548 EDF3 48                    pha   
2549 EDF4 AF EB 00 E1           lda   >EMYPos                  ;always update cursor position in case
2550 EDF8 48                    pha                            ;more than 1 pointing device being used
2551 EDF9 22 60 00 E1           jsl   CUpdate
2552 EDFD
2553 EDFD A3 03        CheckBtns lda   3,s                     ;get interrupt bits
2554 EDFF 29 04 00              and   #BtnIntBit               ;was there a button interrupt?
2555 EE02 D0 04                 bne   Cont                     ;yes
2556 EE04 68                    pla                            ;pull mod keys latch
2557 EE05 68                    pla                            ;pull interrupt bits
2558 EE06 80 6A                 bra   Done
2559 EE08
2560 EE08 20 46 EC     Cont     jsr   SetModBits               ;set up modifiers word in Y
2561 EE0B 68                    pla                            ;pull mod keys latch
2562 EE0C 68                    pla                            ;pull interrupt bits
2563 EE0D
2564 EE0D 5A                    phy                            ;save Y on stack
2565 EE0E F4 00 00              PushWord #0                    ;push space to save btn # in
2566 EE11 F4 00 00              PushWord #0                    ;push space for PostEvent result
2567 EE14 98                    tya                            ;get modifiers word in A
2568 EE15 29 80 00              and   #Btn0Bit                 ;is button 0 currently down?
2569 EE18 D0 10                 bne   Btn0Up                   ;no
2570 EE1A AF E7 00 E1           lda   >EMBStat                 ;check previous status of btn 0
2571 EE1E 0A                    asl   a
2572 EE1F 0A                    asl   a
2573 EE20 B0 18                 bcs   CheckBtn1                ;it was down so no change
2574 EE22 F4 01 00              PushWord #MouseDown            ;it was up
2575 EE25 A9 00 00              lda   #0
2576 EE28 80 36                 bra   PostIt
2577 EE2A
2578 EE2A AF E7 00 E1  Btn0Up   lda   >EMBStat                 ;check previous status of btn 0
2579 EE2E 0A                    asl   a
2580 EE2F 0A                    asl   a
2581 EE30 90 08                 bcc   CheckBtn1                ;it was up so no change
2582 EE32 F4 02 00              PushWord #MouseUp              ;it was down
2583 EE35 A9 00 00              lda   #0
2584 EE38 80 26                 bra   PostIt
2585 EE3A
2586 EE3A A3 05        CheckBtn1 lda   5,s                     ;get modifiers word
2587 EE3C A8                    tay   
2588 EE3D 29 40 00              and   #Btn1Bit                 ;is btn 1 currently down?
2589 EE40 D0 10                 bne   Btn1Up                   ;no
2590 EE42 AF E7 00 E1           lda   >EMBStat                 ;check previous status of btn 1
2591 EE46 EB                    xba   
2592 EE47 4A                    lsr   a
2593 EE48 B0 25                 bcs   NoChange                 ;it was down so no change
2594 EE4A F4 01 00              PushWord #MouseDown 
2595 EE4D A9 01 00              lda   #1
2596 EE50 80 0E                 bra   PostIt
2597 EE52
2598 EE52 AF E7 00 E1  Btn1Up   lda   >EMBStat                 ;check previous status of btn 1
2599 EE56 EB                    xba   
2600 EE57 4A                    lsr   a
2601 EE58 90 15                 bcc   NoChange                 ;it was up so no change
2602 EE5A F4 02 00              PushWord #MouseUp 
2603 EE5D A9 01 00              lda   #1
2604 EE60
2605 EE60 5A           PostIt   phy                            ;push modifiers - hi word of msg
2606 EE61 48                    pha                            ;push button num - lo word of msg
2607 EE62 83 09                 sta   9,s                      ;save button # on stack
2608 EE64 A2 06 14 22           _PostEvent 
2609 EE6B A3 03                 lda   3,s                      ;check button #
2610 EE6D F0 CB                 beq   CheckBtn1                ;if 0 - go check button 1
2611 EE6F 68           NoChange pla                            ;pull result
2612 EE70 68                    pla                            ;pull button #
2613 EE71 68                    pla                            ;pull mods
2614 EE72              Done      
2615 EE72
2616 EE72 E2 30                 sep   #$30                     ;go back to 8 bit mode
2617 EE74                       longa off
2618 EE74                       longi off
2619 EE74 18                    clc   
2620 EE75 6B                    rtl   
2621 EE76                       ENDP 
2622 EE76
2623 EE76
2624 EE76
2625 EE76              ****************************************************************
2626 EE76              *
2627 EE76              * Desk Accessory Interrupt Handler
2628 EE76              *
2629 EE76              ****************************************************************
2630 EE76
2631 EE76                       EXPORT DeskAcc 
2632 EE76              DeskAcc  PROC 
2633 EE76                       longa on
2634 EE76                       longi on
2635 EE76 C2 30                 rep   #$30                     ;go into 16 bit mode
2636 EE78 F4 00 00              PushWord #0                    ;push result
2637 EE7B F4 0A 00              PushWord #DeskAccessory        ;Desk Accessory event
2638 EE7E F4 00 00              PushWord #0                    ;push event message
2639 EE81 F4 00 00              PushWord #0 
2640 EE84 A2 06 14 22           _PostEvent 
2641 EE8B 68                    pla                            ;pull result
2642 EE8C E2 30                 sep   #$30                     ;go back to 8 bit mode
2643 EE8E                       longa off
2644 EE8E                       longi off
2645 EE8E 18                    clc   
2646 EE8F 6B                    rtl   
2647 EE90                       ENDP 
2648 EE90
2649 EE90
2650 EE90
2651 EE90              ****************************************************************
2652 EE90              *
2653 EE90              * Flush Buffer Interrupt Handler
2654 EE90              *
2655 EE90              ****************************************************************
2656 EE90
2657 EE90                       EXPORT FlushBuf 
2658 EE90              FlushBuf PROC 
2659 EE90                       longa on
2660 EE90                       longi on
2661 EE90 C2 30                 rep   #$30                     ;go into 16 bit mode
2662 EE92 F4 00 00              PushWord #0                    ;push result
2663 EE95 F4 28 00              PushWord #$28                  ;key-down and auto-key events
2664 EE98 F4 00 00              PushWord #0                    ;stop mask
2665 EE9B A2 06 15 22           _FlushEvents 
2666 EEA2 68                    pla                            ;pull result
2667 EEA3 E2 30                 sep   #$30                     ;go back to 8 bit mode
2668 EEA5                       longa off
2669 EEA5                       longi off
2670 EEA5 18                    clc   
2671 EEA6 6B                    rtl   
2672 EEA7                       ENDP 
2673 EEA7
2674 EEA7
2675 EEA7              ****************************************************************
2676 EEA7              *
2677 EEA7              * Heartbeat Task for Mouse Card
2678 EEA7              *
2679 EEA7              ****************************************************************
2680 EEA7
2681 EEA7              MouseTask PROC 
2682 EEA7
2683 EEA7                       longa on
2684 EEA7                       longi on
2685 EEA7 C2 30                 rep   #$30                     ;go into 16 bit mode
2686 EEA9 A9 01 00              lda   #1
2687 EEAC 8F F1 00 E1           sta   >TaskHead+4              ;set task counter back to 1
2688 EEB0
2689 EEB0 F4 00 00              PushWord #0                    ;space for fake ServeMouse result
2690 EEB3
2691 EEB3                       longa off
2692 EEB3                       longi off
2693 EEB3 E2 30                 sep   #$30                     ;go into 8 bit mode
2694 EEB5 AF 25 C0 00           lda   >ModLatch
2695 EEB9 48                    pha                            ;push mod keys latch
2696 EEBA A9 00                 lda   #0
2697 EEBC 48                    pha                            ;push lo byte
2698 EEBD                       longa on
2699 EEBD                       longi on
2700 EEBD C2 30                 rep   #$30                     ;go into 16 bit mode
2701 EEBF
2702 EEBF F4 00 00              PushWord #0                    ;push 3 words for readMouse2 result
2703 EEC2 F4 00 00              PushWord #0 
2704 EEC5 F4 00 00              PushWord #0 
2705 EEC8 A2 03 33 22           _readMouse2 
2706 EECF
2707 EECF A0 00 00              ldy   #0                       ;set change flag to 0
2708 EED2 A3 01                 lda   1,s                      ;get BStat
2709 EED4 29 00 20              and   #MovedBit                ;did mouse move?
2710 EED7 F0 08                 beq   CheckBtn0                ;no
2711 EED9 A3 09                 lda   9,s                      ;get fake ServeMouse result
2712 EEDB 09 02 00              ora   #MoveIntBit              ;fake a movement interrupt
2713 EEDE 83 09                 sta   9,s
2714 EEE0 C8                    iny                            ;flag change
2715 EEE1
2716 EEE1 A3 01        CheckBtn0 lda   1,s                     ;get BStat
2717 EEE3 0A                    asl   a                        ;is btn 0 down?
2718 EEE4 90 05                 bcc   Btn0Up                   ;no
2719 EEE6 0A                    asl   a                        ;yes - so check if was down on last read
2720 EEE7 90 18                 bcc   SetBtnBit                ;was up so button state changed
2721 EEE9 B0 03                 bcs   CheckBtn1                ;was down so no change
2722 EEEB
2723 EEEB 0A           Btn0Up   asl   a                        ;was button down on last read?
2724 EEEC B0 13                 bcs   SetBtnBit                ;yes so state changed
2725 EEEE
2726 EEEE A3 01        CheckBtn1 lda   1,s                     ;get BStat back
2727 EEF0 EB                    xba   
2728 EEF1 AA                    tax                            ;save BStat
2729 EEF2 29 10 00              and   #$10                     ;is btn 1 down?
2730 EEF5 F0 06                 beq   Btn1Up                   ;no
2731 EEF7 8A                    txa                            ;yes - so check if was down on last read
2732 EEF8 4A                    lsr   a
2733 EEF9 90 06                 bcc   SetBtnBit                ;was up so button state changed
2734 EEFB B0 0C                 bcs   Done                     ;was down so no change
2735 EEFD
2736 EEFD 8A           Btn1Up   txa   
2737 EEFE 4A                    lsr   a                        ;was button down on last read?
2738 EEFF 90 08                 bcc   Done                     ;no - so no change
2739 EF01
2740 EF01 A3 09        SetBtnBit lda   9,s                     ;get fake ServeMouse result
2741 EF03 09 04 00              ora   #BtnIntBit               ;fake a button interrupt
2742 EF06 83 09                 sta   9,s
2743 EF08 C8                    iny                            ;flag change
2744 EF09 98           Done     tya                            ;did mouse state change?
2745 EF0A F0 03                 beq   Return                   ;no
2746 EF0C 4C E0 ED              jmp   Mouse2                   ;jmp into mouse interrupt handler
2747 EF0F 68           Return   pla                            ;pull stuff off stack
2748 EF10 68                    pla   
2749 EF11 68                    pla   
2750 EF12 68                    pla   
2751 EF13 68                    pla   
2752 EF14 E2 30                 sep   #$30                     ;go back to 8 bit mode
2753 EF16                       longa off
2754 EF16                       longi off
2755 EF16 6B                    rtl   
2756 EF17                       ENDP 
2757 EF17
2758 EF17
2759 EF17
2760 EF17              ****************************************************************
2761 EF17              *
2762 EF17              SetAutoKeyLimit PROC 
2763 EF17              *
2764 EF17              * Sets the AutoKeyLimit to the value passed.
2765 EF17              *
2766 EF17              *
2767 EF17              * Inputs:
2768 EF17              *	NewLimit
2769 EF17              *
2770 EF17              * Outputs:
2771 EF17              *	none
2772 EF17              *
2773 EF17              * External Refs:
2774 EF17              *	none
2775 EF17              *
2776 EF17              * Entry Points:
2777 EF17              *	none
2778 EF17              *
2779 EF17                       longa on                       ; mode
2780 EF17                       longi on
2781 EF17              *
2782 EF17              * Change History
2783 EF17              *
2784 EF17              * 30 Jun 88	Steven Glass & Cheryl Ewy
2785 EF17              *
2786 EF17              * Added to allow App to set AutoKeyLimit
2787 EF17              *
2788 EF17              ****************************************************************
2789 EF17                       DefineStack 
2790 EF17              OrigD    word 
2791 EF17              RTL1     block 3 
2792 EF17              RTL2     block 3 
2793 EF17              NewLimit word 
2794 EF17
2795 EF17 0B                    phd   
2796 EF18 5B                    tcd   
2797 EF19 D0 07                 bne   DoIt
2798 EF1B A2 03 06              ldx   #ActiveErr
2799 EF1E 5C FB FB FE           jml   ErrOut2
2800 EF22
2801 EF22              DoIt      
2802 EF22 A3 09                 lda   NewLimit,s
2803 EF24 1A                    inc   a
2804 EF25 85 64                 sta   <AutoKeyLimit
2805 EF27 5C F8 FB FE           jml   EndCall2
2806 EF2B
2807 EF2B                       ENDP 
2808 EF2B
2809 EF2B                       END   
